/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ReUnicodePropertyNode;
import java.util.Objects;

public class ReUnicodeScriptNode
extends ReUnicodePropertyNode {
    public ReUnicodeScriptNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Node scriptStart() {
        return this.childInBucket(0);
    }

    public Node reUnicodePropertyValue() {
        return this.childInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"scriptStart", "reUnicodePropertyValue"};
    }

    public ReUnicodeScriptNode modify(Node scriptStart, Node reUnicodePropertyValue) {
        if (this.checkForReferenceEquality(scriptStart, reUnicodePropertyValue)) {
            return this;
        }
        return NodeFactory.createReUnicodeScriptNode(scriptStart, reUnicodePropertyValue);
    }

    public ReUnicodeScriptNodeModifier modify() {
        return new ReUnicodeScriptNodeModifier(this);
    }

    public static class ReUnicodeScriptNodeModifier {
        private final ReUnicodeScriptNode oldNode;
        private Node scriptStart;
        private Node reUnicodePropertyValue;

        public ReUnicodeScriptNodeModifier(ReUnicodeScriptNode oldNode) {
            this.oldNode = oldNode;
            this.scriptStart = oldNode.scriptStart();
            this.reUnicodePropertyValue = oldNode.reUnicodePropertyValue();
        }

        public ReUnicodeScriptNodeModifier withScriptStart(Node scriptStart) {
            Objects.requireNonNull(scriptStart, "scriptStart must not be null");
            this.scriptStart = scriptStart;
            return this;
        }

        public ReUnicodeScriptNodeModifier withReUnicodePropertyValue(Node reUnicodePropertyValue) {
            Objects.requireNonNull(reUnicodePropertyValue, "reUnicodePropertyValue must not be null");
            this.reUnicodePropertyValue = reUnicodePropertyValue;
            return this;
        }

        public ReUnicodeScriptNode apply() {
            return this.oldNode.modify(this.scriptStart, this.reUnicodePropertyValue);
        }
    }
}

