/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class RestParameterNode
extends ParameterNode {
    public RestParameterNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public NodeList<AnnotationNode> annotations() {
        return new NodeList<AnnotationNode>((NonTerminalNode)this.childInBucket(0));
    }

    public Node typeName() {
        return this.childInBucket(1);
    }

    public Token ellipsisToken() {
        return (Token)this.childInBucket(2);
    }

    public Optional<Token> paramName() {
        return this.optionalChildInBucket(3);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"annotations", "typeName", "ellipsisToken", "paramName"};
    }

    public RestParameterNode modify(NodeList<AnnotationNode> annotations, Node typeName, Token ellipsisToken, Token paramName) {
        if (this.checkForReferenceEquality(annotations.underlyingListNode(), typeName, ellipsisToken, paramName)) {
            return this;
        }
        return NodeFactory.createRestParameterNode(annotations, typeName, ellipsisToken, paramName);
    }

    public RestParameterNodeModifier modify() {
        return new RestParameterNodeModifier(this);
    }

    public static class RestParameterNodeModifier {
        private final RestParameterNode oldNode;
        private NodeList<AnnotationNode> annotations;
        private Node typeName;
        private Token ellipsisToken;
        private Token paramName;

        public RestParameterNodeModifier(RestParameterNode oldNode) {
            this.oldNode = oldNode;
            this.annotations = oldNode.annotations();
            this.typeName = oldNode.typeName();
            this.ellipsisToken = oldNode.ellipsisToken();
            this.paramName = oldNode.paramName().orElse(null);
        }

        public RestParameterNodeModifier withAnnotations(NodeList<AnnotationNode> annotations) {
            Objects.requireNonNull(annotations, "annotations must not be null");
            this.annotations = annotations;
            return this;
        }

        public RestParameterNodeModifier withTypeName(Node typeName) {
            Objects.requireNonNull(typeName, "typeName must not be null");
            this.typeName = typeName;
            return this;
        }

        public RestParameterNodeModifier withEllipsisToken(Token ellipsisToken) {
            Objects.requireNonNull(ellipsisToken, "ellipsisToken must not be null");
            this.ellipsisToken = ellipsisToken;
            return this;
        }

        public RestParameterNodeModifier withParamName(Token paramName) {
            this.paramName = paramName;
            return this;
        }

        public RestParameterNode apply() {
            return this.oldNode.modify(this.annotations, this.typeName, this.ellipsisToken, this.paramName);
        }
    }
}

