/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class StartActionNode
extends ExpressionNode {
    public StartActionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public NodeList<AnnotationNode> annotations() {
        return new NodeList<AnnotationNode>((NonTerminalNode)this.childInBucket(0));
    }

    public Token startKeyword() {
        return (Token)this.childInBucket(1);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"annotations", "startKeyword", "expression"};
    }

    public StartActionNode modify(NodeList<AnnotationNode> annotations, Token startKeyword, ExpressionNode expression) {
        if (this.checkForReferenceEquality(annotations.underlyingListNode(), startKeyword, expression)) {
            return this;
        }
        return NodeFactory.createStartActionNode(annotations, startKeyword, expression);
    }

    public StartActionNodeModifier modify() {
        return new StartActionNodeModifier(this);
    }

    public static class StartActionNodeModifier {
        private final StartActionNode oldNode;
        private NodeList<AnnotationNode> annotations;
        private Token startKeyword;
        private ExpressionNode expression;

        public StartActionNodeModifier(StartActionNode oldNode) {
            this.oldNode = oldNode;
            this.annotations = oldNode.annotations();
            this.startKeyword = oldNode.startKeyword();
            this.expression = oldNode.expression();
        }

        public StartActionNodeModifier withAnnotations(NodeList<AnnotationNode> annotations) {
            Objects.requireNonNull(annotations, "annotations must not be null");
            this.annotations = annotations;
            return this;
        }

        public StartActionNodeModifier withStartKeyword(Token startKeyword) {
            Objects.requireNonNull(startKeyword, "startKeyword must not be null");
            this.startKeyword = startKeyword;
            return this;
        }

        public StartActionNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public StartActionNode apply() {
            return this.oldNode.modify(this.annotations, this.startKeyword, this.expression);
        }
    }
}

