/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.Objects;
import java.util.Optional;

public class TableTypeDescriptorNode
extends TypeDescriptorNode {
    public TableTypeDescriptorNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token tableKeywordToken() {
        return (Token)this.childInBucket(0);
    }

    public Node rowTypeParameterNode() {
        return this.childInBucket(1);
    }

    public Optional<Node> keyConstraintNode() {
        return this.optionalChildInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"tableKeywordToken", "rowTypeParameterNode", "keyConstraintNode"};
    }

    public TableTypeDescriptorNode modify(Token tableKeywordToken, Node rowTypeParameterNode, Node keyConstraintNode) {
        if (this.checkForReferenceEquality(tableKeywordToken, rowTypeParameterNode, keyConstraintNode)) {
            return this;
        }
        return NodeFactory.createTableTypeDescriptorNode(tableKeywordToken, rowTypeParameterNode, keyConstraintNode);
    }

    public TableTypeDescriptorNodeModifier modify() {
        return new TableTypeDescriptorNodeModifier(this);
    }

    public static class TableTypeDescriptorNodeModifier {
        private final TableTypeDescriptorNode oldNode;
        private Token tableKeywordToken;
        private Node rowTypeParameterNode;
        private Node keyConstraintNode;

        public TableTypeDescriptorNodeModifier(TableTypeDescriptorNode oldNode) {
            this.oldNode = oldNode;
            this.tableKeywordToken = oldNode.tableKeywordToken();
            this.rowTypeParameterNode = oldNode.rowTypeParameterNode();
            this.keyConstraintNode = oldNode.keyConstraintNode().orElse(null);
        }

        public TableTypeDescriptorNodeModifier withTableKeywordToken(Token tableKeywordToken) {
            Objects.requireNonNull(tableKeywordToken, "tableKeywordToken must not be null");
            this.tableKeywordToken = tableKeywordToken;
            return this;
        }

        public TableTypeDescriptorNodeModifier withRowTypeParameterNode(Node rowTypeParameterNode) {
            Objects.requireNonNull(rowTypeParameterNode, "rowTypeParameterNode must not be null");
            this.rowTypeParameterNode = rowTypeParameterNode;
            return this;
        }

        public TableTypeDescriptorNodeModifier withKeyConstraintNode(Node keyConstraintNode) {
            this.keyConstraintNode = keyConstraintNode;
            return this;
        }

        public TableTypeDescriptorNode apply() {
            return this.oldNode.modify(this.tableKeywordToken, this.rowTypeParameterNode, this.keyConstraintNode);
        }
    }
}

