/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class TrapExpressionNode
extends ExpressionNode {
    public TrapExpressionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token trapKeyword() {
        return (Token)this.childInBucket(0);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"trapKeyword", "expression"};
    }

    public TrapExpressionNode modify(SyntaxKind kind, Token trapKeyword, ExpressionNode expression) {
        if (this.checkForReferenceEquality(trapKeyword, expression)) {
            return this;
        }
        return NodeFactory.createTrapExpressionNode(kind, trapKeyword, expression);
    }

    public TrapExpressionNodeModifier modify() {
        return new TrapExpressionNodeModifier(this);
    }

    public static class TrapExpressionNodeModifier {
        private final TrapExpressionNode oldNode;
        private Token trapKeyword;
        private ExpressionNode expression;

        public TrapExpressionNodeModifier(TrapExpressionNode oldNode) {
            this.oldNode = oldNode;
            this.trapKeyword = oldNode.trapKeyword();
            this.expression = oldNode.expression();
        }

        public TrapExpressionNodeModifier withTrapKeyword(Token trapKeyword) {
            Objects.requireNonNull(trapKeyword, "trapKeyword must not be null");
            this.trapKeyword = trapKeyword;
            return this;
        }

        public TrapExpressionNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public TrapExpressionNode apply() {
            return this.oldNode.modify(this.oldNode.kind(), this.trapKeyword, this.expression);
        }
    }
}

