/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class TypeDefinitionNode
extends ModuleMemberDeclarationNode {
    public TypeDefinitionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Optional<MetadataNode> metadata() {
        return this.optionalChildInBucket(0);
    }

    public Optional<Token> visibilityQualifier() {
        return this.optionalChildInBucket(1);
    }

    public Token typeKeyword() {
        return (Token)this.childInBucket(2);
    }

    public Token typeName() {
        return (Token)this.childInBucket(3);
    }

    public Node typeDescriptor() {
        return this.childInBucket(4);
    }

    public Token semicolonToken() {
        return (Token)this.childInBucket(5);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"metadata", "visibilityQualifier", "typeKeyword", "typeName", "typeDescriptor", "semicolonToken"};
    }

    public TypeDefinitionNode modify(MetadataNode metadata, Token visibilityQualifier, Token typeKeyword, Token typeName, Node typeDescriptor, Token semicolonToken) {
        if (this.checkForReferenceEquality(metadata, visibilityQualifier, typeKeyword, typeName, typeDescriptor, semicolonToken)) {
            return this;
        }
        return NodeFactory.createTypeDefinitionNode(metadata, visibilityQualifier, typeKeyword, typeName, typeDescriptor, semicolonToken);
    }

    public TypeDefinitionNodeModifier modify() {
        return new TypeDefinitionNodeModifier(this);
    }

    public static class TypeDefinitionNodeModifier {
        private final TypeDefinitionNode oldNode;
        private MetadataNode metadata;
        private Token visibilityQualifier;
        private Token typeKeyword;
        private Token typeName;
        private Node typeDescriptor;
        private Token semicolonToken;

        public TypeDefinitionNodeModifier(TypeDefinitionNode oldNode) {
            this.oldNode = oldNode;
            this.metadata = oldNode.metadata().orElse(null);
            this.visibilityQualifier = oldNode.visibilityQualifier().orElse(null);
            this.typeKeyword = oldNode.typeKeyword();
            this.typeName = oldNode.typeName();
            this.typeDescriptor = oldNode.typeDescriptor();
            this.semicolonToken = oldNode.semicolonToken();
        }

        public TypeDefinitionNodeModifier withMetadata(MetadataNode metadata) {
            this.metadata = metadata;
            return this;
        }

        public TypeDefinitionNodeModifier withVisibilityQualifier(Token visibilityQualifier) {
            this.visibilityQualifier = visibilityQualifier;
            return this;
        }

        public TypeDefinitionNodeModifier withTypeKeyword(Token typeKeyword) {
            Objects.requireNonNull(typeKeyword, "typeKeyword must not be null");
            this.typeKeyword = typeKeyword;
            return this;
        }

        public TypeDefinitionNodeModifier withTypeName(Token typeName) {
            Objects.requireNonNull(typeName, "typeName must not be null");
            this.typeName = typeName;
            return this;
        }

        public TypeDefinitionNodeModifier withTypeDescriptor(Node typeDescriptor) {
            Objects.requireNonNull(typeDescriptor, "typeDescriptor must not be null");
            this.typeDescriptor = typeDescriptor;
            return this;
        }

        public TypeDefinitionNodeModifier withSemicolonToken(Token semicolonToken) {
            Objects.requireNonNull(semicolonToken, "semicolonToken must not be null");
            this.semicolonToken = semicolonToken;
            return this;
        }

        public TypeDefinitionNode apply() {
            return this.oldNode.modify(this.metadata, this.visibilityQualifier, this.typeKeyword, this.typeName, this.typeDescriptor, this.semicolonToken);
        }
    }
}

