/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.OnFailClauseNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class WhileStatementNode
extends StatementNode {
    public WhileStatementNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token whileKeyword() {
        return (Token)this.childInBucket(0);
    }

    public ExpressionNode condition() {
        return (ExpressionNode)this.childInBucket(1);
    }

    public BlockStatementNode whileBody() {
        return (BlockStatementNode)this.childInBucket(2);
    }

    public Optional<OnFailClauseNode> onFailClause() {
        return this.optionalChildInBucket(3);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"whileKeyword", "condition", "whileBody", "onFailClause"};
    }

    public WhileStatementNode modify(Token whileKeyword, ExpressionNode condition, BlockStatementNode whileBody, OnFailClauseNode onFailClause) {
        if (this.checkForReferenceEquality(whileKeyword, condition, whileBody, onFailClause)) {
            return this;
        }
        return NodeFactory.createWhileStatementNode(whileKeyword, condition, whileBody, onFailClause);
    }

    public WhileStatementNodeModifier modify() {
        return new WhileStatementNodeModifier(this);
    }

    public static class WhileStatementNodeModifier {
        private final WhileStatementNode oldNode;
        private Token whileKeyword;
        private ExpressionNode condition;
        private BlockStatementNode whileBody;
        private OnFailClauseNode onFailClause;

        public WhileStatementNodeModifier(WhileStatementNode oldNode) {
            this.oldNode = oldNode;
            this.whileKeyword = oldNode.whileKeyword();
            this.condition = oldNode.condition();
            this.whileBody = oldNode.whileBody();
            this.onFailClause = oldNode.onFailClause().orElse(null);
        }

        public WhileStatementNodeModifier withWhileKeyword(Token whileKeyword) {
            Objects.requireNonNull(whileKeyword, "whileKeyword must not be null");
            this.whileKeyword = whileKeyword;
            return this;
        }

        public WhileStatementNodeModifier withCondition(ExpressionNode condition) {
            Objects.requireNonNull(condition, "condition must not be null");
            this.condition = condition;
            return this;
        }

        public WhileStatementNodeModifier withWhileBody(BlockStatementNode whileBody) {
            Objects.requireNonNull(whileBody, "whileBody must not be null");
            this.whileBody = whileBody;
            return this;
        }

        public WhileStatementNodeModifier withOnFailClause(OnFailClauseNode onFailClause) {
            this.onFailClause = onFailClause;
            return this;
        }

        public WhileStatementNode apply() {
            return this.oldNode.modify(this.whileKeyword, this.condition, this.whileBody, this.onFailClause);
        }
    }
}

