/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.XMLItemNode;
import java.util.Objects;

public class XMLTextNode
extends XMLItemNode {
    public XMLTextNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token content() {
        return (Token)this.childInBucket(0);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"content"};
    }

    public XMLTextNode modify(Token content) {
        if (this.checkForReferenceEquality(content)) {
            return this;
        }
        return NodeFactory.createXMLTextNode(content);
    }

    public XMLTextNodeModifier modify() {
        return new XMLTextNodeModifier(this);
    }

    public static class XMLTextNodeModifier {
        private final XMLTextNode oldNode;
        private Token content;

        public XMLTextNodeModifier(XMLTextNode oldNode) {
            this.oldNode = oldNode;
            this.content = oldNode.content();
        }

        public XMLTextNodeModifier withContent(Token content) {
            Objects.requireNonNull(content, "content must not be null");
            this.content = content;
            return this;
        }

        public XMLTextNode apply() {
            return this.oldNode.modify(this.content);
        }
    }
}

