/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.constraint.validators.interfaces;

import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.constraint.Constants;
import io.ballerina.stdlib.constraint.ConstraintErrorInfo;
import io.ballerina.stdlib.constraint.InternalValidationException;
import java.util.List;
import java.util.Map;

public interface LengthValidator {
    default public void validate(Map.Entry<BString, Object> constraint, Object fieldValue, boolean isMemberValue, List<ConstraintErrorInfo> failedConstraints, String path) {
        Object constraintValue = constraint.getValue();
        String message = null;
        if (constraintValue instanceof BMap) {
            message = ((BMap)constraintValue).getStringValue(Constants.MESSAGE).getValue();
            constraintValue = ((BMap)constraintValue).get((Object)Constants.VALUE);
        }
        switch (constraint.getKey().getValue()) {
            case "length": {
                if (this.validateLength(fieldValue, (Long)constraintValue)) break;
                failedConstraints.add(new ConstraintErrorInfo(path, message, "length", isMemberValue));
                break;
            }
            case "minLength": {
                if (this.validateMinLength(fieldValue, (Long)constraintValue)) break;
                failedConstraints.add(new ConstraintErrorInfo(path, message, "minLength", isMemberValue));
                break;
            }
            case "maxLength": {
                if (this.validateMaxLength(fieldValue, (Long)constraintValue)) break;
                failedConstraints.add(new ConstraintErrorInfo(path, message, "maxLength", isMemberValue));
                break;
            }
        }
    }

    default public void checkLengthConstraintValue(Map.Entry<BString, Object> constraint, String path) {
        Object constraintValue = constraint.getValue() instanceof BMap ? ((BMap)constraint.getValue()).get((Object)Constants.VALUE) : constraint.getValue();
        switch (constraint.getKey().getValue()) {
            case "length": 
            case "minLength": 
            case "maxLength": {
                long constraintLongValue = (Long)constraintValue;
                String constraintField = constraint.getKey().getValue();
                if (constraintLongValue > 0L) break;
                throw new InternalValidationException("invalid value found for " + path + ":" + constraintField + " constraint. Length constraints should be positive");
            }
        }
    }

    public boolean validateLength(Object var1, long var2);

    public boolean validateMinLength(Object var1, long var2);

    public boolean validateMaxLength(Object var1, long var2);
}

