/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.observe.metrics.extension.defaultimpl;

import io.ballerina.runtime.observability.metrics.AbstractMetric;
import io.ballerina.runtime.observability.metrics.Gauge;
import io.ballerina.runtime.observability.metrics.MetricId;
import io.ballerina.runtime.observability.metrics.Snapshot;
import io.ballerina.runtime.observability.metrics.StatisticConfig;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;
import org.ballerinalang.observe.metrics.extension.defaultimpl.Clock;
import org.ballerinalang.observe.metrics.extension.defaultimpl.RollingHistogram;

public class DefaultGauge
extends AbstractMetric
implements Gauge {
    private static final RollingHistogram[] EMPTY_ROLLING_HISTOGRAMS = new RollingHistogram[0];
    private static final Snapshot[] EMPTY_SNAPSHOTS = new Snapshot[0];
    private final LongAdder count = new LongAdder();
    private final DoubleAdder sum = new DoubleAdder();
    private final DoubleAdder value = new DoubleAdder();
    private final RollingHistogram[] rollingHistograms;

    private DefaultGauge(MetricId id, Clock clock, StatisticConfig ... statisticConfigs) {
        super(id);
        if (statisticConfigs != null) {
            this.rollingHistograms = new RollingHistogram[statisticConfigs.length];
            for (int i = 0; i < statisticConfigs.length; ++i) {
                this.rollingHistograms[i] = new RollingHistogram(clock, statisticConfigs[i]);
            }
        } else {
            this.rollingHistograms = EMPTY_ROLLING_HISTOGRAMS;
        }
    }

    DefaultGauge(MetricId id, StatisticConfig ... statisticConfigs) {
        this(id, Clock.DEFAULT, statisticConfigs);
    }

    private void updateHistogram(double value) {
        this.count.increment();
        this.sum.add(value);
        for (RollingHistogram rollingHistogram : this.rollingHistograms) {
            rollingHistogram.record(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment(double amount) {
        DefaultGauge defaultGauge = this;
        synchronized (defaultGauge) {
            this.value.add(amount);
            this.updateHistogram(this.value.sum());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrement(double amount) {
        DefaultGauge defaultGauge = this;
        synchronized (defaultGauge) {
            this.value.add(-amount);
            this.updateHistogram(this.value.sum());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(double value) {
        DefaultGauge defaultGauge = this;
        synchronized (defaultGauge) {
            this.value.reset();
            this.value.add(value);
            this.updateHistogram(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getValue() {
        DefaultGauge defaultGauge = this;
        synchronized (defaultGauge) {
            return this.value.sum();
        }
    }

    public long getCount() {
        return this.count.sum();
    }

    public double getSum() {
        return this.sum.sum();
    }

    public Snapshot[] getSnapshots() {
        if (this.rollingHistograms.length == 0) {
            return EMPTY_SNAPSHOTS;
        }
        Snapshot[] snapshots = new Snapshot[this.rollingHistograms.length];
        for (int i = 0; i < this.rollingHistograms.length; ++i) {
            snapshots[i] = this.rollingHistograms[i].getSnapshot();
        }
        return snapshots;
    }

    public StatisticConfig[] getStatisticsConfig() {
        StatisticConfig[] configs = new StatisticConfig[this.rollingHistograms.length];
        int index = 0;
        for (RollingHistogram rollingHistogram : this.rollingHistograms) {
            configs[index] = rollingHistogram.getStatisticConfig();
            ++index;
        }
        return configs;
    }
}

