/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.io.channels.base;

import io.ballerina.stdlib.io.channels.base.Buffer;
import io.ballerina.stdlib.io.channels.base.Channel;
import io.ballerina.stdlib.io.channels.base.IOChannel;
import io.ballerina.stdlib.io.utils.BallerinaIOException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;

public class CharacterChannel
implements IOChannel {
    private Channel channel;
    private CharsetDecoder bytesDecoder;
    private CharsetEncoder byteEncoder;
    private CharBuffer charBuffer;
    private Buffer contentBuffer;
    private String encoding;
    private static final char UN_MAPPABLE_CHARACTER = '\ufffd';
    private static final int MAX_BYTES_PER_CHAR = 3;
    private static final int MINIMUM_BYTE_BUFFER_SIZE = 0;

    public CharacterChannel(Channel channel, String encoding) {
        this.channel = channel;
        this.encoding = encoding;
        this.bytesDecoder = Charset.forName(encoding).newDecoder();
        this.byteEncoder = Charset.forName(encoding).newEncoder();
        this.contentBuffer = new Buffer(0);
        this.bytesDecoder.onMalformedInput(CodingErrorAction.REPLACE);
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    private int getNumberOfCharactersRemaining() {
        int limit = this.charBuffer.limit();
        int position = this.charBuffer.position();
        return limit - position;
    }

    private void appendCharsToString(StringBuilder content, int characterCount) {
        boolean indexCharacterOffset = false;
        char[] remainingChars = new char[characterCount];
        this.charBuffer.get(remainingChars, 0, characterCount);
        content.append(remainingChars);
    }

    private void appendRemainingCharacters(StringBuilder content) {
        if (null != this.charBuffer) {
            int numberOfCharactersRemaining = this.getNumberOfCharactersRemaining();
            int numberOfCharsRequired = content.capacity();
            boolean minimumCharacterCount = false;
            if (numberOfCharsRequired < numberOfCharactersRemaining) {
                numberOfCharactersRemaining = numberOfCharsRequired;
            }
            if (numberOfCharactersRemaining > 0) {
                this.appendCharsToString(content, numberOfCharactersRemaining);
            }
        }
    }

    private boolean isMalformedCharacter(char character) {
        return character == '\ufffd';
    }

    private int getNumberOfBytesInContent(int length) {
        char[] availableContent = new char[length];
        this.charBuffer.get(availableContent, 0, length);
        byte[] bytes = new String(availableContent).getBytes(this.bytesDecoder.charset());
        this.charBuffer = CharBuffer.wrap(availableContent);
        return bytes.length;
    }

    private void asyncReadBytesFromChannel(int numberOfBytesRequired, int numberOfCharsRequired) throws BallerinaIOException {
        CharBuffer intermediateCharacterBuffer;
        ByteBuffer buffer;
        int numberOfCharsProcessed = 0;
        this.charBuffer = CharBuffer.allocate(numberOfBytesRequired);
        try {
            buffer = this.contentBuffer.get(numberOfBytesRequired, this.channel);
        }
        catch (IOException e) {
            throw new BallerinaIOException("error occurred while reading from channel: " + e.getMessage(), e);
        }
        try {
            intermediateCharacterBuffer = this.bytesDecoder.decode(buffer);
        }
        catch (CharacterCodingException e) {
            throw new BallerinaIOException("character decoding error while reading from buffer: " + e.getMessage(), e);
        }
        this.charBuffer.put(intermediateCharacterBuffer);
        this.charBuffer.flip();
        this.processChars(numberOfCharsRequired, buffer, numberOfCharsProcessed += intermediateCharacterBuffer.limit());
    }

    private String asyncReadBytesFromChannel(int numberOfBytesRequired) throws IOException {
        CharBuffer intermediateCharacterBuffer;
        ByteBuffer buffer;
        do {
            buffer = this.contentBuffer.get(numberOfBytesRequired, this.channel);
            intermediateCharacterBuffer = this.bytesDecoder.decode(buffer);
        } while (!this.channel.hasReachedEnd() && buffer.hasRemaining());
        return intermediateCharacterBuffer.toString();
    }

    private void processChars(int numberOfCharsRequired, ByteBuffer buffer, int numberOfCharsProcessed) throws BallerinaIOException {
        boolean minimumNumberOfCharsRequired = false;
        if (numberOfCharsProcessed > 0) {
            int lastCharacterIndex = numberOfCharsProcessed - 1;
            char lastCharacterProcessed = this.charBuffer.get(lastCharacterIndex);
            if (numberOfCharsRequired < numberOfCharsProcessed && this.isMalformedCharacter(lastCharacterProcessed)) {
                int numberOfBytesWithoutTheLastChar = this.getNumberOfBytesInContent(lastCharacterIndex);
                int numberOfBytesAllocatedForLastChar = buffer.capacity() - numberOfBytesWithoutTheLastChar;
                this.contentBuffer.reverse(numberOfBytesAllocatedForLastChar);
            }
        }
    }

    public String read(int numberOfCharacters) throws BallerinaIOException {
        StringBuilder content = new StringBuilder(numberOfCharacters);
        int numberOfBytesRequired = numberOfCharacters * 3;
        this.appendRemainingCharacters(content);
        int charsRequiredToBeReadFromChannel = content.capacity() - content.length();
        if (charsRequiredToBeReadFromChannel == 0) {
            return content.toString();
        }
        this.asyncReadBytesFromChannel(numberOfBytesRequired, numberOfCharacters);
        if (this.charBuffer.limit() < charsRequiredToBeReadFromChannel) {
            charsRequiredToBeReadFromChannel = this.charBuffer.limit();
        }
        this.appendCharsToString(content, charsRequiredToBeReadFromChannel);
        return content.toString();
    }

    String readAllChars(int nBytes) throws IOException {
        return this.asyncReadBytesFromChannel(nBytes);
    }

    public int write(String content, int offset) throws IOException {
        try {
            int numberOfBytesWritten = 0;
            if (this.channel != null) {
                char[] characters = content.toCharArray();
                CharBuffer characterBuffer = CharBuffer.wrap(characters);
                characterBuffer.position(offset);
                ByteBuffer encodedBuffer = this.byteEncoder.encode(characterBuffer);
                do {
                    numberOfBytesWritten += this.channel.write(encodedBuffer);
                } while (encodedBuffer.hasRemaining());
            }
            return numberOfBytesWritten;
        }
        catch (CharacterCodingException e) {
            String message = "error occurred while writing bytes to the channel: " + e.getMessage();
            throw new IOException(message, e);
        }
    }

    @Override
    public int id() {
        return this.channel.id();
    }

    @Override
    public boolean hasReachedEnd() {
        return null != this.charBuffer && null != this.channel && !this.charBuffer.hasRemaining() && this.channel.hasReachedEnd();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public boolean remaining() {
        return null != this.charBuffer && this.charBuffer.hasRemaining();
    }

    public String getEncoding() {
        return this.encoding;
    }
}

