/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.io.nativeimpl;

import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.io.channels.AbstractNativeChannel;
import io.ballerina.stdlib.io.channels.BlobChannel;
import io.ballerina.stdlib.io.channels.BlobIOChannel;
import io.ballerina.stdlib.io.channels.FileIOChannel;
import io.ballerina.stdlib.io.channels.base.Channel;
import io.ballerina.stdlib.io.utils.BallerinaIOException;
import io.ballerina.stdlib.io.utils.IOConstants;
import io.ballerina.stdlib.io.utils.IOUtils;
import io.ballerina.stdlib.io.utils.Utils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;

public class ByteChannelUtils
extends AbstractNativeChannel {
    private static final String STREAM_BLOCK_ENTRY = "value";
    private static final String IS_CLOSED = "isClosed";

    private ByteChannelUtils() {
    }

    public static Object read(BObject channel, long nBytes) {
        int arraySize = nBytes <= 0L ? 16384 : (int)nBytes;
        Channel byteChannel = (Channel)channel.getNativeData("byteChannel");
        ByteBuffer content = ByteBuffer.wrap(new byte[arraySize]);
        if (byteChannel.hasReachedEnd()) {
            return IOUtils.createEoFError();
        }
        try {
            byteChannel.read(content);
            return ValueCreator.createArrayValue((byte[])ByteChannelUtils.getContentData(content));
        }
        catch (ClosedChannelException e) {
            return IOUtils.createError("Byte channel is already closed.");
        }
        catch (Exception e) {
            String msg = "error occurred while reading bytes from the channel. " + e.getMessage();
            return IOUtils.createError(msg);
        }
    }

    public static Object readAll(BObject channel) {
        try {
            if (ByteChannelUtils.isChannelClosed(channel)) {
                return IOUtils.createError("Byte channel is already closed.");
            }
            BufferedInputStream bufferedInputStream = ByteChannelUtils.getBufferedInputStream(channel);
            if (bufferedInputStream != null) {
                return ValueCreator.createArrayValue((byte[])bufferedInputStream.readAllBytes());
            }
            return IOUtils.createError("BufferedInputStream is not initialized");
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object readBlock(BObject channel, long blockSize) {
        int blockSizeInt = (int)blockSize;
        try {
            BufferedInputStream bufferedInputStream = ByteChannelUtils.getBufferedInputStream(channel);
            if (bufferedInputStream == null) return IOUtils.createError("BufferedInputStream is not initialized");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                byte[] buffer = new byte[blockSizeInt];
                int n = bufferedInputStream.read(buffer, 0, blockSizeInt);
                if (n == -1) {
                    bufferedInputStream.close();
                    BError bError = IOUtils.createEoFError();
                    return bError;
                }
                output.write(buffer, 0, n);
                BArray bArray = ValueCreator.createArrayValue((byte[])output.toByteArray());
                return bArray;
            }
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
    }

    private static byte[] getContentData(ByteBuffer contentBuffer) {
        int bufferSize = contentBuffer.limit();
        int readPosition = contentBuffer.position();
        byte[] content = contentBuffer.array();
        boolean startPosition = false;
        if (readPosition == bufferSize) {
            return content;
        }
        return Arrays.copyOfRange(content, 0, readPosition);
    }

    public static Object base64Encode(BObject channel) {
        return Utils.encodeByteChannel(channel, false);
    }

    public static Object base64Decode(BObject channel) {
        return Utils.decodeByteChannel(channel, false);
    }

    public static Object closeByteChannel(BObject channel) {
        if (ByteChannelUtils.isChannelClosed(channel)) {
            return IOUtils.createError("Byte channel is already closed.");
        }
        Channel byteChannel = (Channel)channel.getNativeData("byteChannel");
        try {
            BufferedInputStream bufferedInputStream = ByteChannelUtils.getBufferedInputStream(channel);
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
            byteChannel.close();
            channel.addNativeData(IS_CLOSED, (Object)true);
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
        return null;
    }

    public static Object closeInputStream(BObject channel) {
        try {
            BufferedInputStream bufferedInputStream = ByteChannelUtils.getBufferedInputStream(channel);
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
            return null;
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
    }

    public static Object write(BObject channel, BArray content, long offset) {
        Channel byteChannel = (Channel)channel.getNativeData("byteChannel");
        ByteBuffer writeBuffer = ByteBuffer.wrap(content.getBytes());
        writeBuffer.position((int)offset);
        try {
            if (byteChannel != null) {
                return byteChannel.write(writeBuffer);
            }
            return IOUtils.createError(IOConstants.ErrorCode.GenericError, "WritableByteChannel is not initialized");
        }
        catch (ClosedChannelException e) {
            return IOUtils.createError(IOConstants.ErrorCode.GenericError, "Byte channel is already closed.");
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
    }

    public static Object openReadableFile(BString pathUrl) {
        BObject readableByteChannel;
        try {
            readableByteChannel = ByteChannelUtils.createChannel(ByteChannelUtils.inFlow(pathUrl.getValue(), IOConstants.FileOpenOption.READ));
            Channel channel = (Channel)readableByteChannel.getNativeData("byteChannel");
            BufferedInputStream bufferedInputStream = new BufferedInputStream(channel.getInputStream());
            readableByteChannel.addNativeData("bufferedInputStreamEntry", (Object)bufferedInputStream);
            readableByteChannel.addNativeData(IS_CLOSED, (Object)false);
        }
        catch (BallerinaIOException | IOException e) {
            return IOUtils.createError(IOConstants.ErrorCode.GenericError, e.getMessage());
        }
        catch (BError e) {
            return e;
        }
        return readableByteChannel;
    }

    public static Object openWritableFile(BString pathUrl, BString option) {
        BObject writableByteChannel;
        try {
            writableByteChannel = IOConstants.FileOpenOption.OVERWRITE.name().equals(option.getValue()) ? ByteChannelUtils.createChannel(ByteChannelUtils.inFlow(pathUrl.getValue(), IOConstants.FileOpenOption.OVERWRITE)) : ByteChannelUtils.createChannel(ByteChannelUtils.inFlow(pathUrl.getValue(), IOConstants.FileOpenOption.APPEND));
            writableByteChannel.addNativeData(IS_CLOSED, (Object)false);
        }
        catch (BallerinaIOException e) {
            return IOUtils.createError(e);
        }
        catch (BError e) {
            return e;
        }
        return writableByteChannel;
    }

    public static Object createReadableChannel(BArray content) {
        try {
            Channel channel = ByteChannelUtils.inFlow(content);
            return ByteChannelUtils.createChannel(channel);
        }
        catch (Exception e) {
            return IOUtils.createError(e);
        }
    }

    private static Channel inFlow(String pathUrl, IOConstants.FileOpenOption option) throws BallerinaIOException {
        FileIOChannel channel;
        Path path = Paths.get(pathUrl, new String[0]);
        if (option.equals((Object)IOConstants.FileOpenOption.READ)) {
            FileChannel fileChannel = IOUtils.openFileChannelExtended(path, option);
            channel = new FileIOChannel(fileChannel);
            channel.setReadable(true);
        } else {
            FileChannel fileChannel = IOUtils.openFileChannelExtended(path, option);
            channel = new FileIOChannel(fileChannel);
        }
        return channel;
    }

    private static Channel inFlow(BArray contentArr) {
        byte[] content = ByteChannelUtils.shrink(contentArr);
        ByteArrayInputStream contentStream = new ByteArrayInputStream(content);
        ReadableByteChannel readableByteChannel = Channels.newChannel(contentStream);
        return new BlobIOChannel(new BlobChannel(readableByteChannel));
    }

    private static byte[] shrink(BArray array) {
        int contentLength = array.size();
        byte[] content = new byte[contentLength];
        System.arraycopy(array.getBytes(), 0, content, 0, contentLength);
        return content;
    }

    private static boolean isChannelClosed(BObject channel) {
        if (channel.getNativeData(IS_CLOSED) != null) {
            return (Boolean)channel.getNativeData(IS_CLOSED);
        }
        return false;
    }

    private static BufferedInputStream getBufferedInputStream(BObject channel) throws IOException {
        if (channel.getNativeData("bufferedInputStreamEntry") != null) {
            return (BufferedInputStream)channel.getNativeData("bufferedInputStreamEntry");
        }
        Channel byteChannel = (Channel)channel.getNativeData("byteChannel");
        BufferedInputStream bufferedInputStream = new BufferedInputStream(byteChannel.getInputStream());
        channel.addNativeData("bufferedInputStreamEntry", (Object)bufferedInputStream);
        return bufferedInputStream;
    }
}

