/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.io.nativeimpl;

import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.io.channels.base.Channel;
import io.ballerina.stdlib.io.channels.base.DataChannel;
import io.ballerina.stdlib.io.channels.base.Representation;
import io.ballerina.stdlib.io.utils.IOUtils;
import java.io.IOException;
import java.nio.ByteOrder;

public class DataChannelUtils {
    private static final String IS_CLOSED = "isClosed";

    private DataChannelUtils() {
    }

    private static ByteOrder getByteOrder(String byteOrder) {
        switch (byteOrder) {
            case "BE": {
                return ByteOrder.BIG_ENDIAN;
            }
            case "LE": {
                return ByteOrder.LITTLE_ENDIAN;
            }
        }
        return ByteOrder.nativeOrder();
    }

    public static void initReadableDataChannel(BObject dataChannelObj, BObject byteChannelObj, BString order) {
        try {
            ByteOrder byteOrder = DataChannelUtils.getByteOrder(order.getValue());
            Channel channel = (Channel)byteChannelObj.getNativeData("byteChannel");
            DataChannel dataChannel = new DataChannel(channel, byteOrder);
            dataChannelObj.addNativeData("data_channel", (Object)dataChannel);
            dataChannelObj.addNativeData(IS_CLOSED, (Object)false);
        }
        catch (Exception e) {
            String message = "error while creating data channel: " + e.getMessage();
            throw IOUtils.createError(message);
        }
    }

    public static Object readInt16(BObject dataChannelObj) {
        if (DataChannelUtils.isChannelClosed(dataChannelObj)) {
            return IOUtils.createError("Data channel is already closed.");
        }
        DataChannel channel = (DataChannel)dataChannelObj.getNativeData("data_channel");
        try {
            return channel.readLong(Representation.BIT_16).getValue();
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
    }

    public static Object readInt32(BObject dataChannelObj) {
        if (DataChannelUtils.isChannelClosed(dataChannelObj)) {
            return IOUtils.createError("Data channel is already closed.");
        }
        DataChannel channel = (DataChannel)dataChannelObj.getNativeData("data_channel");
        try {
            return channel.readLong(Representation.BIT_32).getValue();
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
    }

    public static Object readInt64(BObject dataChannelObj) {
        if (DataChannelUtils.isChannelClosed(dataChannelObj)) {
            return IOUtils.createError("Data channel is already closed.");
        }
        DataChannel channel = (DataChannel)dataChannelObj.getNativeData("data_channel");
        try {
            return channel.readLong(Representation.BIT_64).getValue();
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
    }

    public static Object readFloat32(BObject dataChannelObj) {
        if (DataChannelUtils.isChannelClosed(dataChannelObj)) {
            return IOUtils.createError("Data channel is already closed.");
        }
        DataChannel channel = (DataChannel)dataChannelObj.getNativeData("data_channel");
        try {
            return channel.readDouble(Representation.BIT_32);
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
    }

    public static Object readFloat64(BObject dataChannelObj) {
        if (DataChannelUtils.isChannelClosed(dataChannelObj)) {
            return IOUtils.createError("Data channel is already closed.");
        }
        DataChannel channel = (DataChannel)dataChannelObj.getNativeData("data_channel");
        try {
            return channel.readDouble(Representation.BIT_64);
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
    }

    public static Object readBool(BObject dataChannelObj) {
        if (DataChannelUtils.isChannelClosed(dataChannelObj)) {
            return IOUtils.createError("Data channel is already closed.");
        }
        DataChannel channel = (DataChannel)dataChannelObj.getNativeData("data_channel");
        try {
            return channel.readBoolean();
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
    }

    public static Object readString(BObject dataChannelObj, long nBytes, BString encoding) {
        if (DataChannelUtils.isChannelClosed(dataChannelObj)) {
            return IOUtils.createError("Data channel is already closed.");
        }
        DataChannel channel = (DataChannel)dataChannelObj.getNativeData("data_channel");
        if (channel.hasReachedEnd()) {
            return IOUtils.createEoFError();
        }
        try {
            return StringUtils.fromString((String)channel.readString((int)nBytes, encoding.getValue()));
        }
        catch (IOException e) {
            String msg = "Error occurred while reading string: " + e.getMessage();
            return IOUtils.createError(msg);
        }
    }

    public static Object readVarInt(BObject dataChannelObj) {
        if (DataChannelUtils.isChannelClosed(dataChannelObj)) {
            return IOUtils.createError("Data channel is already closed.");
        }
        DataChannel channel = (DataChannel)dataChannelObj.getNativeData("data_channel");
        try {
            return channel.readLong(Representation.VARIABLE).getValue();
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
    }

    public static Object closeDataChannel(BObject dataChannel) {
        if (DataChannelUtils.isChannelClosed(dataChannel)) {
            return IOUtils.createError("Data channel is already closed.");
        }
        DataChannel channel = (DataChannel)dataChannel.getNativeData("data_channel");
        try {
            channel.close();
            dataChannel.addNativeData(IS_CLOSED, (Object)true);
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
        return null;
    }

    public static void initWritableDataChannel(BObject dataChannelObj, BObject byteChannelObj, BString order) {
        try {
            ByteOrder byteOrder = DataChannelUtils.getByteOrder(order.getValue());
            Channel channel = (Channel)byteChannelObj.getNativeData("byteChannel");
            DataChannel dataChannel = new DataChannel(channel, byteOrder);
            dataChannelObj.addNativeData("data_channel", (Object)dataChannel);
        }
        catch (Exception e) {
            String message = "error while creating data channel: " + e.getMessage();
            throw IOUtils.createError(message);
        }
    }

    public static Object writeInt16(BObject dataChannelObj, long value) {
        if (DataChannelUtils.isChannelClosed(dataChannelObj)) {
            return IOUtils.createError("Data channel is already closed.");
        }
        DataChannel channel = (DataChannel)dataChannelObj.getNativeData("data_channel");
        try {
            channel.writeLong(value, Representation.BIT_16);
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
        return null;
    }

    public static Object writeInt32(BObject dataChannelObj, long value) {
        if (DataChannelUtils.isChannelClosed(dataChannelObj)) {
            return IOUtils.createError("Data channel is already closed.");
        }
        DataChannel channel = (DataChannel)dataChannelObj.getNativeData("data_channel");
        try {
            channel.writeLong(value, Representation.BIT_32);
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
        return null;
    }

    public static Object writeInt64(BObject dataChannelObj, long value) {
        if (DataChannelUtils.isChannelClosed(dataChannelObj)) {
            return IOUtils.createError("Data channel is already closed.");
        }
        DataChannel channel = (DataChannel)dataChannelObj.getNativeData("data_channel");
        try {
            channel.writeLong(value, Representation.BIT_64);
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
        return null;
    }

    public static Object writeFloat32(BObject dataChannelObj, double value) {
        if (DataChannelUtils.isChannelClosed(dataChannelObj)) {
            return IOUtils.createError("Data channel is already closed.");
        }
        DataChannel channel = (DataChannel)dataChannelObj.getNativeData("data_channel");
        try {
            channel.writeDouble(value, Representation.BIT_32);
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
        return null;
    }

    public static Object writeFloat64(BObject dataChannelObj, double value) {
        if (DataChannelUtils.isChannelClosed(dataChannelObj)) {
            return IOUtils.createError("Data channel is already closed.");
        }
        DataChannel channel = (DataChannel)dataChannelObj.getNativeData("data_channel");
        try {
            channel.writeDouble(value, Representation.BIT_64);
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
        return null;
    }

    public static Object writeBool(BObject dataChannelObj, boolean value) {
        if (DataChannelUtils.isChannelClosed(dataChannelObj)) {
            return IOUtils.createError("Data channel is already closed.");
        }
        DataChannel channel = (DataChannel)dataChannelObj.getNativeData("data_channel");
        try {
            channel.writeBoolean(value);
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
        return null;
    }

    public static Object writeString(BObject dataChannelObj, BString value, BString encoding) {
        if (DataChannelUtils.isChannelClosed(dataChannelObj)) {
            return IOUtils.createError("Data channel is already closed.");
        }
        DataChannel channel = (DataChannel)dataChannelObj.getNativeData("data_channel");
        try {
            channel.writeString(value.getValue(), encoding.getValue());
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
        return null;
    }

    public static Object writeVarInt(BObject dataChannelObj, long value) {
        if (DataChannelUtils.isChannelClosed(dataChannelObj)) {
            return IOUtils.createError("Data channel is already closed.");
        }
        DataChannel channel = (DataChannel)dataChannelObj.getNativeData("data_channel");
        try {
            channel.writeLong(value, Representation.VARIABLE);
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
        return null;
    }

    private static boolean isChannelClosed(BObject channel) {
        if (channel.getNativeData(IS_CLOSED) != null) {
            return (Boolean)channel.getNativeData(IS_CLOSED);
        }
        return false;
    }
}

