/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.io.nativeimpl;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.StructureType;
import io.ballerina.runtime.api.types.TableType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BTable;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.stdlib.io.channels.base.DelimitedRecordChannel;
import io.ballerina.stdlib.io.utils.BallerinaIOException;
import io.ballerina.stdlib.io.utils.IOUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToTable {
    private static final Logger log = LoggerFactory.getLogger(ToTable.class);
    private static final String CSV_CHANNEL_DELIMITED_STRUCT_FIELD = "dc";

    private ToTable() {
    }

    public static Object toTable(BObject csvChannel, BTypedesc typedescValue, BArray key) {
        try {
            BObject delimitedObj = (BObject)csvChannel.get(StringUtils.fromString((String)CSV_CHANNEL_DELIMITED_STRUCT_FIELD));
            DelimitedRecordChannel delimitedChannel = (DelimitedRecordChannel)delimitedObj.getNativeData("txt_record");
            if (delimitedChannel.hasReachedEnd()) {
                return IOUtils.createEoFError();
            }
            ArrayList<String[]> records = new ArrayList<String[]>();
            while (delimitedChannel.hasNext()) {
                records.add(delimitedChannel.read());
            }
            return ToTable.toTable(typedescValue, key, records);
        }
        catch (BError | BallerinaIOException e) {
            String msg = "failed to process the delimited file: " + e.getMessage();
            return IOUtils.createError(msg);
        }
    }

    private static BTable toTable(BTypedesc typedescValue, BArray key, List<String[]> records) {
        Type describingType = typedescValue.getDescribingType();
        TableType newTableType = key.size() == 0 ? TypeCreator.createTableType((Type)describingType, (boolean)false) : TypeCreator.createTableType((Type)describingType, (String[])key.getStringArray(), (boolean)false);
        BTable table = ValueCreator.createTableValue((TableType)newTableType);
        StructureType structType = (StructureType)describingType;
        for (String[] fields : records) {
            Map<String, Object> struct = ToTable.getStruct(fields, structType);
            if (struct == null) continue;
            table.add((Object)ValueCreator.createRecordValue((Module)describingType.getPackage(), (String)describingType.getName(), struct));
        }
        return table;
    }

    private static Map<String, Object> getStruct(String[] fields, StructureType structType) {
        Map internalStructFields = structType.getFields();
        int fieldLength = internalStructFields.size();
        HashMap<String, Object> struct = null;
        if (fields.length > 0) {
            Iterator itr = internalStructFields.entrySet().iterator();
            struct = new HashMap<String, Object>();
            for (int i = 0; i < fieldLength; ++i) {
                Field internalStructField = (Field)itr.next().getValue();
                int type = internalStructField.getFieldType().getTag();
                String fieldName = internalStructField.getFieldName();
                if (fields.length > i) {
                    String value = fields[i];
                    switch (type) {
                        case 1: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            ToTable.populateRecord(type, struct, fieldName, value);
                            break;
                        }
                        case 33: {
                            List members = ((UnionType)internalStructField.getFieldType()).getMemberTypes();
                            if (((Type)members.get(0)).getTag() == 14) {
                                ToTable.populateRecord(((Type)members.get(1)).getTag(), struct, fieldName, value);
                                break;
                            }
                            if (((Type)members.get(1)).getTag() == 14) {
                                ToTable.populateRecord(((Type)members.get(0)).getTag(), struct, fieldName, value);
                                break;
                            }
                            throw IOUtils.createError("unsupported nillable field for value: " + value);
                        }
                        default: {
                            throw IOUtils.createError("type casting support only for int, float, boolean and string. Invalid value for the struct field: " + value);
                        }
                    }
                    continue;
                }
                struct.put(fieldName, null);
            }
        }
        return struct;
    }

    private static void populateRecord(int type, Map<String, Object> struct, String fieldName, String value) {
        if (value == null || value.isEmpty()) {
            struct.put(fieldName, null);
        } else {
            String trimmedValue = value.trim();
            switch (type) {
                case 1: {
                    struct.put(fieldName, Long.parseLong(trimmedValue));
                    return;
                }
                case 3: {
                    struct.put(fieldName, Double.parseDouble(trimmedValue));
                    break;
                }
                case 4: {
                    struct.put(fieldName, ValueCreator.createDecimalValue((String)trimmedValue));
                    break;
                }
                case 5: {
                    struct.put(fieldName, trimmedValue);
                    break;
                }
                case 6: {
                    struct.put(fieldName, Boolean.parseBoolean(trimmedValue));
                    break;
                }
                default: {
                    throw IOUtils.createError("type casting support only for int, float, boolean and string. Invalid value for the struct field: " + value);
                }
            }
        }
    }
}

