/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.commons.completion;

import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemCapabilities;
import org.eclipse.lsp4j.InsertTextFormat;

public abstract class AbstractLSCompletionItem
implements LSCompletionItem {
    protected CompletionItem completionItem;
    private final LSCompletionItem.CompletionItemType itemType;

    public AbstractLSCompletionItem(BallerinaCompletionContext context, CompletionItem completionItem, LSCompletionItem.CompletionItemType itemType) {
        this.completionItem = completionItem;
        this.itemType = itemType;
        this.setInsertTextFormat(context);
    }

    @Override
    public CompletionItem getCompletionItem() {
        return this.completionItem;
    }

    @Override
    public LSCompletionItem.CompletionItemType getType() {
        return this.itemType;
    }

    private String getPlainTextSnippet(String snippet) {
        return snippet.replaceAll("\\$\\{\\d+:([^\\{^\\}]*)\\}", "$1").replaceAll("(\\$\\{\\d+\\})", "");
    }

    private void setInsertTextFormat(BallerinaCompletionContext context) {
        boolean isSnippetSupported;
        CompletionItemCapabilities itemCapabilities = context.getCapabilities().getCompletionItem();
        boolean bl = isSnippetSupported = itemCapabilities != null && Boolean.TRUE.equals(itemCapabilities.getSnippetSupport());
        if (!isSnippetSupported) {
            this.completionItem.setInsertText(this.getPlainTextSnippet(this.completionItem.getInsertText()));
            this.completionItem.setInsertTextFormat(InsertTextFormat.PlainText);
        } else {
            this.completionItem.setInsertTextFormat(InsertTextFormat.Snippet);
        }
    }
}

