/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.commons.toml.common;

import io.ballerina.toml.syntax.tree.NonTerminalNode;
import io.ballerina.toml.syntax.tree.SeparatedNodeList;
import io.ballerina.toml.syntax.tree.ValueNode;
import io.ballerina.tools.text.TextRange;
import org.ballerinalang.langserver.commons.toml.visitor.ValueType;

public final class TomlSyntaxTreeUtil {
    public static final String NUMBER = "Number";
    public static final String STRING = "String";
    public static final String BOOLEAN = "Boolean";
    public static final String ARRAY = "Array";
    public static final String TABLE_ARRAY = "Table Array";
    public static final String TABLE = "Table";

    private TomlSyntaxTreeUtil() {
    }

    public static String toQualifiedName(SeparatedNodeList<ValueNode> nodeList) {
        StringBuilder output = new StringBuilder();
        for (ValueNode valueNode : nodeList) {
            String valueString = valueNode.toString().trim();
            output.append(".").append(valueString);
        }
        return output.substring(1).trim();
    }

    public static boolean withinTextRange(int position, NonTerminalNode node) {
        TextRange rangeWithMinutiae = node.textRangeWithMinutiae();
        TextRange textRange = node.textRange();
        TextRange leadingMinutiaeRange = TextRange.from((int)rangeWithMinutiae.startOffset(), (int)(textRange.startOffset() - rangeWithMinutiae.startOffset()));
        return leadingMinutiaeRange.endOffset() <= position;
    }

    public static String trimResourcePath(String resourcePath) {
        if ((resourcePath = resourcePath.trim()).startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        if (resourcePath.endsWith("/")) {
            resourcePath = resourcePath.substring(0, resourcePath.length() - 1);
        }
        return resourcePath;
    }

    public static String getDefaultValueForType(ValueType type) {
        return switch (type) {
            case ValueType.NUMBER -> "0";
            case ValueType.BOOLEAN -> "false";
            default -> "";
        };
    }
}

