/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.commons.toml.visitor;

import io.ballerina.toml.validator.schema.AbstractSchema;
import io.ballerina.toml.validator.schema.ArraySchema;
import io.ballerina.toml.validator.schema.BooleanSchema;
import io.ballerina.toml.validator.schema.NumericSchema;
import io.ballerina.toml.validator.schema.Schema;
import io.ballerina.toml.validator.schema.SchemaVisitor;
import io.ballerina.toml.validator.schema.StringSchema;
import io.ballerina.toml.validator.schema.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.ballerinalang.langserver.commons.toml.common.TomlCommonUtil;
import org.ballerinalang.langserver.commons.toml.visitor.Array;
import org.ballerinalang.langserver.commons.toml.visitor.KeyValuePair;
import org.ballerinalang.langserver.commons.toml.visitor.Table;
import org.ballerinalang.langserver.commons.toml.visitor.TableArray;
import org.ballerinalang.langserver.commons.toml.visitor.TomlNode;
import org.ballerinalang.langserver.commons.toml.visitor.TomlNodeType;
import org.ballerinalang.langserver.commons.toml.visitor.ValueType;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.InsertTextFormat;

public class TomlSchemaVisitor
extends SchemaVisitor {
    private final Map<TomlNode, Map<String, CompletionItem>> completions = new HashMap<TomlNode, Map<String, CompletionItem>>();
    private Map<String, CompletionItem> currentTopLevelNodePropertyMap;
    private TomlNode topLevelNodeKey;

    public void visit(Schema objectSchema) {
        Map properties = objectSchema.properties();
        HashMap<String, CompletionItem> completionStoreForCurrentTopLevelNode = this.currentTopLevelNodePropertyMap != null ? this.currentTopLevelNodePropertyMap : new HashMap<String, CompletionItem>();
        block7: for (Map.Entry property : properties.entrySet()) {
            String propertyKey = (String)property.getKey();
            AbstractSchema propertyValue = (AbstractSchema)property.getValue();
            switch (propertyValue.type()) {
                case OBJECT: {
                    propertyKey = this.getQualifiedTableKey(propertyKey);
                    Table tableNode = new Table(propertyKey);
                    CompletionItem item = this.generateCompletionItem(tableNode, "Table");
                    completionStoreForCurrentTopLevelNode.put(propertyKey, item);
                    HashMap<String, CompletionItem> store = new HashMap<String, CompletionItem>();
                    this.visitNode(propertyValue, tableNode, store);
                    this.completions.put(tableNode, store);
                    continue block7;
                }
                case ARRAY: {
                    this.visitNode(propertyValue, new Array(propertyKey, this.getQualifiedTableKey(propertyKey), ValueType.ARRAY), completionStoreForCurrentTopLevelNode);
                    continue block7;
                }
                case STRING: {
                    this.visitNode(propertyValue, new KeyValuePair(propertyKey, ValueType.STRING), completionStoreForCurrentTopLevelNode);
                    continue block7;
                }
                case INTEGER: {
                    this.visitNode(propertyValue, new KeyValuePair(propertyKey, ValueType.NUMBER), completionStoreForCurrentTopLevelNode);
                    continue block7;
                }
                case BOOLEAN: {
                    this.visitNode(propertyValue, new KeyValuePair(propertyKey, ValueType.BOOLEAN), completionStoreForCurrentTopLevelNode);
                    continue block7;
                }
            }
            this.visitNode(propertyValue, new Table(propertyKey), completionStoreForCurrentTopLevelNode);
        }
    }

    public void visit(ArraySchema arraySchema) {
        AbstractSchema items = arraySchema.items();
        if (items.type() == Type.OBJECT) {
            Map<String, CompletionItem> topLevelNodeStore = this.currentTopLevelNodePropertyMap;
            TableArray tableArray = new TableArray(((Array)this.topLevelNodeKey).getQname());
            CompletionItem item = this.generateCompletionItem(tableArray, "Table Array");
            topLevelNodeStore.put(tableArray.getKey(), item);
            this.topLevelNodeKey = tableArray;
            HashMap<String, CompletionItem> store = new HashMap<String, CompletionItem>();
            this.visitNode(items, this.topLevelNodeKey, store);
            this.completions.put(this.topLevelNodeKey, store);
        } else if (items.type() == Type.ARRAY) {
            String arrayKey = ((Array)this.topLevelNodeKey).getQname();
            this.visitNode(items, new Array(arrayKey, arrayKey, ValueType.ARRAY), this.currentTopLevelNodePropertyMap);
        } else {
            CompletionItem item = this.generateCompletionItem(this.topLevelNodeKey, "Array");
            this.currentTopLevelNodePropertyMap.put(this.topLevelNodeKey.getKey(), item);
        }
    }

    public void visit(BooleanSchema booleanSchema) {
        CompletionItem item = this.generateCompletionItem(this.topLevelNodeKey, "Boolean");
        this.currentTopLevelNodePropertyMap.put(this.topLevelNodeKey.getKey(), item);
    }

    public void visit(NumericSchema numericSchema) {
        CompletionItem item = this.generateCompletionItem(this.topLevelNodeKey, "Number");
        this.currentTopLevelNodePropertyMap.put(this.topLevelNodeKey.getKey(), item);
    }

    public void visit(StringSchema stringSchema) {
        CompletionItem item = this.generateCompletionItem(this.topLevelNodeKey, "String");
        this.currentTopLevelNodePropertyMap.put(this.topLevelNodeKey.getKey(), item);
    }

    private void visitNode(AbstractSchema schema, TomlNode newKey, Map<String, CompletionItem> newTopLevelStore) {
        TomlNode oldKey = this.topLevelNodeKey;
        Map<String, CompletionItem> oldStore = this.currentTopLevelNodePropertyMap;
        this.topLevelNodeKey = newKey;
        this.currentTopLevelNodePropertyMap = newTopLevelStore;
        schema.accept((SchemaVisitor)this);
        this.topLevelNodeKey = oldKey;
        this.currentTopLevelNodePropertyMap = oldStore;
    }

    private String getQualifiedTableKey(String key) {
        if (this.topLevelNodeKey == null) {
            return key;
        }
        return this.topLevelNodeKey.getKey() + "." + key;
    }

    private CompletionItem generateCompletionItem(TomlNode node, String nodeType) {
        CompletionItem item = new CompletionItem();
        item.setInsertText(node.getTomlSyntax());
        item.setDetail("Table");
        item.setLabel(node.getKey());
        item.setKind(CompletionItemKind.Snippet);
        item.setInsertTextFormat(InsertTextFormat.Snippet);
        item.setDetail(nodeType);
        if (node.type() != TomlNodeType.TABLE && node.type() != TomlNodeType.TABLE_ARRAY) {
            item.setSortText(TomlCommonUtil.genSortText(1));
        } else {
            item.setSortText(TomlCommonUtil.genSortText(2));
        }
        return item;
    }

    public Map<TomlNode, Map<String, CompletionItem>> getAllCompletionSnippets() {
        return Collections.unmodifiableMap(this.removeTopLevelKeyCompletionItems(this.completions));
    }

    protected Map<TomlNode, Map<String, CompletionItem>> removeTopLevelKeyCompletionItems(Map<TomlNode, Map<String, CompletionItem>> completions) {
        HashMap<TomlNode, Map<String, CompletionItem>> optimizedCompletions = new HashMap<TomlNode, Map<String, CompletionItem>>();
        Predicate<Map.Entry> filter = item -> !"Table".equals(((CompletionItem)item.getValue()).getDetail()) && !"Table Array".equals(((CompletionItem)item.getValue()).getDetail());
        for (Map.Entry<TomlNode, Map<String, CompletionItem>> entry : completions.entrySet()) {
            TomlNode key = entry.getKey();
            Map<String, CompletionItem> completionItemList = entry.getValue();
            if (completionItemList.entrySet().stream().filter(filter).toList().isEmpty()) continue;
            optimizedCompletions.put(key, completionItemList);
        }
        return optimizedCompletions;
    }
}

