/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.file.utils;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.file.utils.ModuleUtils;
import io.ballerina.stdlib.time.util.TimeValueHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import java.util.HashMap;

public class FileUtils {
    private static final String UNKNOWN_MESSAGE = "Unknown Error";

    public static BError getBallerinaError(String error, Throwable ex) {
        String errorMsg = error != null && ex.getMessage() != null ? ex.getMessage() : UNKNOWN_MESSAGE;
        return FileUtils.getBallerinaError(error, errorMsg);
    }

    public static BError getBallerinaError(String error, String message) {
        return ErrorCreator.createError((Module)ModuleUtils.getModule(), (String)error, (BString)StringUtils.fromString((String)(message != null ? message : UNKNOWN_MESSAGE)), null, null);
    }

    public static Object getMetaData(File inputFile) throws IOException {
        FileTime lastModified = Files.getLastModifiedTime(inputFile.toPath(), new LinkOption[0]);
        HashMap<String, Object> metadataRecord = new HashMap<String, Object>();
        metadataRecord.put("absPath", inputFile.getAbsolutePath());
        metadataRecord.put("size", inputFile.length());
        metadataRecord.put("modifiedTime", TimeValueHandler.createUtcFromMilliSeconds((long)lastModified.toMillis()));
        metadataRecord.put("dir", inputFile.isDirectory());
        metadataRecord.put("readable", Files.isReadable(inputFile.toPath()));
        metadataRecord.put("writable", Files.isWritable(inputFile.toPath()));
        return ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)"MetaData", metadataRecord);
    }

    public static String getSystemProperty(String key) {
        String value = System.getProperty(key);
        if (value == null) {
            return (String)PredefinedTypes.TYPE_STRING.getZeroValue();
        }
        return value;
    }

    public static BError getPathError(String reason, String details) {
        if (reason == null) {
            reason = "GenericError";
        }
        if (details == null) {
            details = UNKNOWN_MESSAGE;
        }
        return ErrorCreator.createError((Module)ModuleUtils.getModule(), (String)reason, (BString)StringUtils.fromString((String)details), null, null);
    }

    private FileUtils() {
    }
}

