/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.converters;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.ArrayDimensionNode;
import io.ballerina.compiler.syntax.tree.ArrayTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.RecordFieldNode;
import io.ballerina.compiler.syntax.tree.RecordRestDescriptorNode;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.converters.JsonToRecordResponse;
import io.ballerina.converters.exception.JsonToRecordConverterException;
import io.ballerina.converters.util.Constants;
import io.ballerina.converters.util.ConverterUtils;
import io.ballerina.converters.util.ErrorMessages;
import io.ballerina.converters.util.SchemaGenerator;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.formatter.core.Formatter;
import org.ballerinalang.formatter.core.FormatterException;
import org.ballerinalang.formatter.core.options.ForceFormattingOptions;
import org.ballerinalang.formatter.core.options.FormattingOptions;

public final class JsonToRecordConverter {
    private JsonToRecordConverter() {
    }

    @Deprecated
    public static JsonToRecordResponse convert(String jsonString, String recordName, boolean isRecordTypeDesc, boolean isClosed) throws IOException, JsonToRecordConverterException, FormatterException {
        return JsonToRecordConverter.convert(jsonString, recordName, isRecordTypeDesc, isClosed, false);
    }

    public static JsonToRecordResponse convert(String jsonString, String recordName, boolean isRecordTypeDesc, boolean isClosed, boolean forceFormatRecordFields) throws IOException, JsonToRecordConverterException, FormatterException {
        OpenAPI model;
        String name = recordName != null && !recordName.isEmpty() ? recordName : "NewRecord";
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode inputJson = objectMapper.readTree(jsonString);
        if (inputJson.has("$schema")) {
            model = JsonToRecordConverter.parseJSONSchema(jsonString, name);
        } else {
            Map<String, Object> schema = SchemaGenerator.generate(inputJson);
            String schemaJson = objectMapper.writeValueAsString(schema);
            model = JsonToRecordConverter.parseJSONSchema(schemaJson, name);
        }
        Map<String, NonTerminalNode> typeDefinitionNodes = JsonToRecordConverter.generateRecords(model, isRecordTypeDesc, isClosed);
        NodeList imports = AbstractNodeFactory.createEmptyNodeList();
        JsonToRecordResponse response = new JsonToRecordResponse();
        ForceFormattingOptions forceFormattingOptions = ForceFormattingOptions.builder().setForceFormatRecordFields(forceFormatRecordFields).build();
        FormattingOptions formattingOptions = FormattingOptions.builder().setForceFormattingOptions(forceFormattingOptions).build();
        if (isRecordTypeDesc) {
            RecordTypeDescriptorNode typeDescriptorNode = (RecordTypeDescriptorNode)typeDefinitionNodes.entrySet().iterator().next().getValue();
            Token semicolon = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN);
            Token typeKeyWord = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD);
            IdentifierToken typeName = AbstractNodeFactory.createIdentifierToken((String)ConverterUtils.escapeIdentifier(name));
            TypeDefinitionNode typeDefinitionNode = NodeFactory.createTypeDefinitionNode(null, null, (Token)typeKeyWord, (Token)typeName, (Node)typeDescriptorNode, (Token)semicolon);
            NodeList moduleMembers = AbstractNodeFactory.createNodeList((Node[])new ModuleMemberDeclarationNode[]{typeDefinitionNode});
            IdentifierToken eofToken = AbstractNodeFactory.createIdentifierToken((String)"");
            ModulePartNode modulePartNode = NodeFactory.createModulePartNode((NodeList)imports, (NodeList)moduleMembers, (Token)eofToken);
            response.setCodeBlock(Formatter.format((SyntaxTree)modulePartNode.syntaxTree(), (FormattingOptions)formattingOptions).toSourceCode());
        } else {
            NodeList moduleMembers = AbstractNodeFactory.createNodeList(typeDefinitionNodes.values());
            IdentifierToken eofToken = AbstractNodeFactory.createIdentifierToken((String)"");
            ModulePartNode modulePartNode = NodeFactory.createModulePartNode((NodeList)imports, (NodeList)moduleMembers, (Token)eofToken);
            response.setCodeBlock(Formatter.format((SyntaxTree)modulePartNode.syntaxTree(), (FormattingOptions)formattingOptions).toSourceCode());
        }
        return response;
    }

    private static Map<String, NonTerminalNode> generateRecords(OpenAPI openApi, boolean isRecordTypeDescriptor, boolean isClosedRecord) throws JsonToRecordConverterException {
        LinkedHashMap<String, NonTerminalNode> typeDefinitionNodes = new LinkedHashMap<String, NonTerminalNode>();
        Components components = openApi.getComponents();
        if (components.getSchemas() == null || openApi.getComponents() == null) {
            return new LinkedHashMap<String, NonTerminalNode>(typeDefinitionNodes);
        }
        RecordRestDescriptorNode restDescriptorNode = isClosedRecord ? null : NodeFactory.createRecordRestDescriptorNode((Node)NodeFactory.createBuiltinSimpleNameReferenceNode((SyntaxKind)SyntaxKind.JSON_KEYWORD, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.JSON_KEYWORD)), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ELLIPSIS_TOKEN), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        Map<String, Schema> schemas = components.getSchemas();
        for (Map.Entry<String, Schema> schema : schemas.entrySet()) {
            BuiltinSimpleNameReferenceNode fieldTypeName;
            List<String> required = schema.getValue().getRequired();
            Token typeKeyWord = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD);
            IdentifierToken typeName = AbstractNodeFactory.createIdentifierToken((String)ConverterUtils.escapeIdentifier(schema.getKey().trim()));
            Token recordKeyWord = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RECORD_KEYWORD);
            Token bodyStartDelimiter = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_PIPE_TOKEN);
            ArrayList<Node> recordFieldList = new ArrayList<Node>();
            Schema schemaValue = schema.getValue();
            String schemaType = schemaValue.getType();
            if (schema.getValue().getProperties() != null || schema.getValue() instanceof ObjectSchema) {
                Map<String, Schema> fields = schema.getValue().getProperties();
                if (fields != null) {
                    for (Map.Entry<String, Schema> field : fields.entrySet()) {
                        JsonToRecordConverter.addRecordFields(required, recordFieldList, field, typeDefinitionNodes, isRecordTypeDescriptor, restDescriptorNode);
                    }
                }
                NodeList fieldNodes = AbstractNodeFactory.createNodeList(recordFieldList);
                Token bodyEndDelimiter = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_PIPE_TOKEN);
                RecordTypeDescriptorNode recordTypeDescriptorNode = NodeFactory.createRecordTypeDescriptorNode((Token)recordKeyWord, (Token)bodyStartDelimiter, (NodeList)fieldNodes, (RecordRestDescriptorNode)restDescriptorNode, (Token)bodyEndDelimiter);
                String key = schema.getKey().trim();
                if (isRecordTypeDescriptor) {
                    typeDefinitionNodes.put(key, (NonTerminalNode)recordTypeDescriptorNode);
                    continue;
                }
                Token semicolon = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN);
                TypeDefinitionNode typeDefinitionNode = NodeFactory.createTypeDefinitionNode(null, null, (Token)typeKeyWord, (Token)typeName, (Node)recordTypeDescriptorNode, (Token)semicolon);
                typeDefinitionNodes.put(key, (NonTerminalNode)typeDefinitionNode);
                continue;
            }
            if (!schemaType.equals("array") || !(schemaValue instanceof ArraySchema)) continue;
            ArraySchema arraySchema = (ArraySchema)schemaValue;
            Token openSBracketToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACKET_TOKEN);
            Token closeSBracketToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACKET_TOKEN);
            IdentifierToken fieldName = AbstractNodeFactory.createIdentifierToken((String)(ConverterUtils.escapeIdentifier(schema.getKey().trim().toLowerCase(Locale.ENGLISH)) + "list"));
            IdentifierToken semicolonToken = AbstractNodeFactory.createIdentifierToken((String)";");
            if (arraySchema.getItems() != null) {
                fieldTypeName = JsonToRecordConverter.extractOpenApiSchema(arraySchema.getItems(), schema.getKey(), typeDefinitionNodes, isRecordTypeDescriptor, restDescriptorNode);
            } else {
                Token type = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.STRING_KEYWORD);
                fieldTypeName = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)type);
            }
            ArrayTypeDescriptorNode arrayField = JsonToRecordConverter.createArrayTypeDesc((TypeDescriptorNode)fieldTypeName, openSBracketToken, null, closeSBracketToken);
            RecordFieldNode recordFieldNode = NodeFactory.createRecordFieldNode(null, null, (Node)arrayField, (Token)fieldName, null, (Token)semicolonToken);
            NodeList fieldNodes = AbstractNodeFactory.createNodeList((Node[])new Node[]{recordFieldNode});
            Token bodyEndDelimiter = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_PIPE_TOKEN);
            RecordTypeDescriptorNode recordTypeDescriptorNode = NodeFactory.createRecordTypeDescriptorNode((Token)recordKeyWord, (Token)bodyStartDelimiter, (NodeList)fieldNodes, (RecordRestDescriptorNode)restDescriptorNode, (Token)bodyEndDelimiter);
            if (isRecordTypeDescriptor) {
                typeDefinitionNodes.put(schema.getKey().trim() + "List", (NonTerminalNode)recordTypeDescriptorNode);
                continue;
            }
            Token semicolon = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN);
            IdentifierToken arrayIdentifier = AbstractNodeFactory.createIdentifierToken((String)ConverterUtils.escapeIdentifier(schema.getKey().trim() + "List"));
            TypeDefinitionNode typeDefinitionNode = NodeFactory.createTypeDefinitionNode(null, null, (Token)typeKeyWord, (Token)arrayIdentifier, (Node)recordTypeDescriptorNode, (Token)semicolon);
            typeDefinitionNodes.put(schema.getKey().trim() + "List", (NonTerminalNode)typeDefinitionNode);
        }
        return new LinkedHashMap<String, NonTerminalNode>(typeDefinitionNodes);
    }

    private static void addRecordFields(List<String> required, List<Node> recordFieldList, Map.Entry<String, Schema> field, Map<String, NonTerminalNode> typeDefinitionNodes, boolean isRecordTypeDescriptor, RecordRestDescriptorNode restDescriptorNode) throws JsonToRecordConverterException {
        TypeDescriptorNode fieldTypeName = JsonToRecordConverter.extractOpenApiSchema(field.getValue(), field.getKey(), typeDefinitionNodes, isRecordTypeDescriptor, restDescriptorNode);
        IdentifierToken fieldName = AbstractNodeFactory.createIdentifierToken((String)ConverterUtils.escapeIdentifier(field.getKey().trim()));
        Token questionMarkToken = required != null && required.contains(field.getKey().trim()) ? null : AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN);
        Token semicolonToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN);
        RecordFieldNode recordFieldNode = NodeFactory.createRecordFieldNode(null, null, (Node)fieldTypeName, (Token)fieldName, (Token)questionMarkToken, (Token)semicolonToken);
        recordFieldList.add((Node)recordFieldNode);
    }

    private static TypeDescriptorNode extractOpenApiSchema(Schema<?> schema, String name, Map<String, NonTerminalNode> typeDefinitionNodes, boolean isRecordTypeDescriptor, RecordRestDescriptorNode restDescriptorNode) throws JsonToRecordConverterException {
        if (schema.getType() == null && schema.getProperties() == null) {
            if (schema.get$ref() != null) {
                IdentifierToken typeName = AbstractNodeFactory.createIdentifierToken((String)ConverterUtils.extractReferenceType(schema.get$ref()));
                return NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)typeName);
            }
            Token typeName = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.JSON_KEYWORD);
            return NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)typeName);
        }
        String schemaType = schema.getType();
        if (schemaType.equals("integer") || schemaType.equals("number") || schemaType.equals("string") || schemaType.equals("boolean")) {
            String type = ConverterUtils.convertOpenAPITypeToBallerina(schemaType.trim());
            IdentifierToken typeName = AbstractNodeFactory.createIdentifierToken((String)type);
            return NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)typeName);
        }
        if (schemaType.equals("object") && schema.getProperties() != null) {
            Map<String, Schema> properties = schema.getProperties();
            List<String> required = schema.getRequired();
            Token typeKeyWord = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD);
            IdentifierToken typeName = AbstractNodeFactory.createIdentifierToken((String)ConverterUtils.escapeIdentifier(StringUtils.capitalize(name)));
            Token recordKeyWord = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RECORD_KEYWORD);
            Token bodyStartDelimiter = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_PIPE_TOKEN);
            Token bodyEndDelimiter = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_PIPE_TOKEN);
            ArrayList<Node> recordFList = new ArrayList<Node>();
            for (Map.Entry<String, Schema> property : properties.entrySet()) {
                JsonToRecordConverter.addRecordFields(required, recordFList, property, typeDefinitionNodes, isRecordTypeDescriptor, restDescriptorNode);
            }
            NodeList fieldNodes = AbstractNodeFactory.createNodeList(recordFList);
            RecordTypeDescriptorNode typeDescriptorNode = NodeFactory.createRecordTypeDescriptorNode((Token)recordKeyWord, (Token)bodyStartDelimiter, (NodeList)fieldNodes, (RecordRestDescriptorNode)restDescriptorNode, (Token)bodyEndDelimiter);
            if (isRecordTypeDescriptor) {
                return typeDescriptorNode;
            }
            Token semicolon = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN);
            TypeDefinitionNode typeDefinitionNode = NodeFactory.createTypeDefinitionNode(null, null, (Token)typeKeyWord, (Token)typeName, (Node)typeDescriptorNode, (Token)semicolon);
            typeDefinitionNodes.put(StringUtils.capitalize(name), (NonTerminalNode)typeDefinitionNode);
            IdentifierToken refTypeName = AbstractNodeFactory.createIdentifierToken((String)StringUtils.capitalize(name));
            return NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)refTypeName);
        }
        if (!schemaType.equals("array") || !(schema instanceof ArraySchema)) {
            Token typeName = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.JSON_KEYWORD);
            return NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)typeName);
        }
        ArraySchema arraySchema = (ArraySchema)schema;
        if (arraySchema.getItems() != null) {
            TypeDescriptorNode memberTypeDesc;
            Token openSBracketToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACKET_TOKEN);
            Token closeSBracketToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACKET_TOKEN);
            if (Objects.equals(arraySchema.getItems().getType(), "object")) {
                String type = StringUtils.capitalize(name) + "Item";
                IdentifierToken typeName = AbstractNodeFactory.createIdentifierToken((String)type);
                if (isRecordTypeDescriptor) {
                    memberTypeDesc = JsonToRecordConverter.extractOpenApiSchema(arraySchema.getItems(), type, typeDefinitionNodes, true, restDescriptorNode);
                } else {
                    memberTypeDesc = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)typeName);
                    JsonToRecordConverter.extractOpenApiSchema(arraySchema.getItems(), type, typeDefinitionNodes, false, restDescriptorNode);
                }
            } else if (arraySchema.getItems() instanceof ArraySchema) {
                memberTypeDesc = JsonToRecordConverter.extractOpenApiSchema(arraySchema.getItems(), name, typeDefinitionNodes, isRecordTypeDescriptor, restDescriptorNode);
            } else {
                String type = arraySchema.getItems().getType();
                IdentifierToken typeName = AbstractNodeFactory.createIdentifierToken((String)ConverterUtils.convertOpenAPITypeToBallerina(type));
                memberTypeDesc = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)typeName);
            }
            return JsonToRecordConverter.createArrayTypeDesc(memberTypeDesc, openSBracketToken, null, closeSBracketToken);
        }
        Token typeName = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.JSON_KEYWORD);
        return NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)typeName);
    }

    private static ArrayTypeDescriptorNode createArrayTypeDesc(TypeDescriptorNode memberTypeDesc, Token openBracketToken, Node arrayLengthNode, Token closeBracketToken) {
        NodeList arrayDimensions = NodeFactory.createEmptyNodeList();
        if (memberTypeDesc.kind() == SyntaxKind.ARRAY_TYPE_DESC) {
            ArrayTypeDescriptorNode innerArrayType = (ArrayTypeDescriptorNode)memberTypeDesc;
            arrayDimensions = innerArrayType.dimensions();
            memberTypeDesc = innerArrayType.memberTypeDesc();
        }
        ArrayDimensionNode arrayDimension = NodeFactory.createArrayDimensionNode((Token)openBracketToken, (Node)arrayLengthNode, (Token)closeBracketToken);
        arrayDimensions = arrayDimensions.add((Node)arrayDimension);
        return NodeFactory.createArrayTypeDescriptorNode((TypeDescriptorNode)memberTypeDesc, (NodeList)arrayDimensions);
    }

    private static OpenAPI parseJSONSchema(String schemaString, String recordName) throws JsonToRecordConverterException, IOException {
        String prefix = "{\n  \"openapi\" : \"3.0.1\",\n  \"info\" : {\n    \"title\" : \" payloadV\",\n    \"version\" : \"1.0.0\"\n  },\n  \"servers\" : [],\n  \"paths\" : {},\n  \"components\" : {\n    \"schemas\" : {\n      \"%s\" : ".formatted(recordName);
        String suffix = "\n    }\n  }\n}";
        ObjectMapper objectMapper = new ObjectMapper();
        Map<String, Object> jsonMap = objectMapper.readValue(schemaString, new TypeReference<Map<String, Object>>(){});
        Map<String, Object> cleanedMap = JsonToRecordConverter.cleanSchema(jsonMap);
        String openAPISchemaString = objectMapper.writeValueAsString(cleanedMap);
        String openAPIFileContent = prefix + openAPISchemaString + suffix;
        SwaggerParseResult parseResult = new OpenAPIV3Parser().readContents(openAPIFileContent);
        if (!parseResult.getMessages().isEmpty()) {
            throw new JsonToRecordConverterException(ErrorMessages.parserException(schemaString));
        }
        return parseResult.getOpenAPI();
    }

    private static Map<String, Object> cleanSchema(Map<String, Object> schemaMap) throws JsonToRecordConverterException {
        Map<String, Object> cleanedMap = JsonToRecordConverter.removeUnsupportedKeywords(schemaMap);
        if (!(cleanedMap.get("type") instanceof String)) {
            throw new JsonToRecordConverterException(ErrorMessages.multipleTypes(cleanedMap.toString()));
        }
        if (cleanedMap.get("type").equals("object")) {
            Map properties = (Map)cleanedMap.get("properties");
            for (Map.Entry entry : properties.entrySet()) {
                Map property = (Map)entry.getValue();
                properties.replace((String)entry.getKey(), JsonToRecordConverter.cleanSchema(property));
            }
            cleanedMap.replace("properties", properties);
        } else if (cleanedMap.get("type").equals("array")) {
            Map<String, Object> itemsSchema = (Map<String, Object>)cleanedMap.get("items");
            Map<String, Object> cleanedSchema = itemsSchema != null && !itemsSchema.isEmpty() ? JsonToRecordConverter.cleanSchema(itemsSchema) : itemsSchema;
            cleanedMap.replace("items", cleanedSchema);
        }
        return cleanedMap;
    }

    private static Map<String, Object> removeUnsupportedKeywords(Map<String, Object> jsonMap) {
        for (String keyword : Constants.OPEN_API_UNSUPPORTED_KEYWORDS) {
            jsonMap.remove(keyword);
        }
        return jsonMap;
    }
}

