/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.tools.text;

import java.util.Objects;

public class TextRange {
    private final int startOffset;
    private final int endOffset;
    private final int length;

    private TextRange(int startOffset, int length) {
        this.startOffset = startOffset;
        this.length = length;
        this.endOffset = startOffset + length;
    }

    public static TextRange from(int startOffset, int length) {
        return new TextRange(startOffset, length);
    }

    public int startOffset() {
        return this.startOffset;
    }

    public int endOffset() {
        return this.endOffset;
    }

    public int length() {
        return this.length;
    }

    public boolean contains(int position) {
        return this.startOffset <= position && position < this.endOffset;
    }

    public boolean intersectionExists(TextRange textRange) {
        return this.startOffset <= textRange.endOffset && textRange.startOffset <= this.endOffset;
    }

    public String toString() {
        return "(" + this.startOffset + "," + this.endOffset + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextRange textRange = (TextRange)o;
        return this.startOffset == textRange.startOffset && this.endOffset == textRange.endOffset;
    }

    public int hashCode() {
        return Objects.hash(this.startOffset, this.endOffset);
    }
}

