/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.constraint.validators;

import io.ballerina.stdlib.constraint.ConstraintErrorInfo;
import io.ballerina.stdlib.constraint.validators.NumberConstraintValidator;
import java.util.List;

public class FloatConstraintValidator
extends NumberConstraintValidator {
    public FloatConstraintValidator(List<ConstraintErrorInfo> failedConstraintsInfo) {
        super(failedConstraintsInfo);
    }

    @Override
    public boolean validateMinValue(Object fieldValue, Object constraintValue) {
        return ((Number)fieldValue).doubleValue() >= (Double)constraintValue;
    }

    @Override
    public boolean validateMaxValue(Object fieldValue, Object constraintValue) {
        return ((Number)fieldValue).doubleValue() <= (Double)constraintValue;
    }

    @Override
    public boolean validateMinValueExclusive(Object fieldValue, Object constraintValue) {
        return ((Number)fieldValue).doubleValue() > (Double)constraintValue;
    }

    @Override
    public boolean validateMaxValueExclusive(Object fieldValue, Object constraintValue) {
        return ((Number)fieldValue).doubleValue() < (Double)constraintValue;
    }
}

