/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.invoker.classload.context;

import io.ballerina.shell.invoker.classload.context.StatementContext;
import io.ballerina.shell.invoker.classload.context.VariableContext;
import io.ballerina.shell.rt.InvokerMemory;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ClassLoadContext {
    private final String contextId;
    private final Collection<String> imports;
    private final Collection<String> moduleDclns;
    private final String lastVarDcln;
    private final Collection<VariableContext> varDclns;
    private final Collection<String> newVarNames;
    private final Collection<StatementContext> lastStmts;

    public ClassLoadContext(String contextId, Collection<String> imports, Collection<String> moduleDclns, Collection<VariableContext> varDclns, Collection<String> newVarNames, String lastVarDcln, Collection<StatementContext> lastStmts) {
        this.lastStmts = Objects.requireNonNullElse(lastStmts, List.of());
        this.lastVarDcln = Objects.requireNonNullElse(lastVarDcln, "");
        this.contextId = Objects.requireNonNull(contextId);
        this.imports = Objects.requireNonNull(imports);
        this.varDclns = Objects.requireNonNull(varDclns);
        this.newVarNames = Objects.requireNonNullElse(newVarNames, List.of());
        this.moduleDclns = Objects.requireNonNull(moduleDclns);
    }

    public ClassLoadContext(String contextId, Collection<String> imports, Collection<String> moduleDclns, Collection<VariableContext> varDclns, Collection<String> newVarNames, String lastVarDcln) {
        this(contextId, imports, moduleDclns, varDclns, newVarNames, lastVarDcln, null);
    }

    public ClassLoadContext(String contextId, Collection<String> imports) {
        this(contextId, imports, List.of(), List.of(), null, null);
    }

    public Collection<String> imports() {
        return this.imports;
    }

    public Collection<String> moduleDclns() {
        return this.moduleDclns;
    }

    public Collection<String> newVarNames() {
        return this.newVarNames;
    }

    public String lastVarDcln() {
        return this.lastVarDcln;
    }

    public Collection<StatementContext> lastStmts() {
        return this.lastStmts;
    }

    public Collection<VariableContext> varDclns() {
        return this.varDclns;
    }

    public String contextId() {
        return this.contextId;
    }

    public String exprVarName() {
        return "__last__";
    }

    public String memoryRef() {
        return InvokerMemory.class.getCanonicalName();
    }

    public boolean noExpressions() {
        return this.lastStmts.stream().allMatch(StatementContext::statement);
    }
}

