/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.parser.trials;

import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.shell.parser.ParserConstants;
import io.ballerina.shell.parser.TrialTreeParser;
import io.ballerina.shell.parser.trials.InvalidMethodException;
import io.ballerina.shell.parser.trials.ParserTrialFailedException;
import io.ballerina.shell.parser.trials.TreeParserTrial;
import java.util.ArrayList;
import java.util.Collection;

public class ExpressionTrial
extends TreeParserTrial {
    private static final String SEMICOLON = ";";

    public ExpressionTrial(TrialTreeParser parentParser) {
        super(parentParser);
    }

    @Override
    public Collection<Node> parse(String source) throws ParserTrialFailedException {
        ArrayList<Node> nodes = new ArrayList<Node>();
        StatementNode parsedNode = source.endsWith(SEMICOLON) ? NodeParser.parseStatement((String)("assignment = " + source)) : NodeParser.parseStatement((String)("assignment = " + source + SEMICOLON));
        if (parsedNode.hasDiagnostics()) {
            throw new ParserTrialFailedException("Error occurred during parsing node as statement node");
        }
        ExpressionNode expressionNode = ((AssignmentStatementNode)parsedNode).expression();
        if (expressionNode.hasDiagnostics()) {
            throw new ParserTrialFailedException("Error occurred during extracting expression from the statement");
        }
        this.validateExpression(expressionNode.toSourceCode());
        nodes.add((Node)expressionNode);
        return nodes;
    }

    private void validateExpression(String expression) {
        String functionName = expression.replaceAll("\\s*\\(.*", "");
        if (ParserConstants.isFunctionNameRestricted(functionName)) {
            String message = String.format("Function name '%s' not allowed in Ballerina Shell.%n", functionName);
            throw new InvalidMethodException(message);
        }
    }
}

