/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.parser.trials;

import io.ballerina.compiler.syntax.tree.FunctionBodyBlockNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.shell.parser.TrialTreeParser;
import io.ballerina.shell.parser.trials.ParserTrialFailedException;
import io.ballerina.shell.parser.trials.TreeParserTrial;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class GetErrorMessageTrial
extends TreeParserTrial {
    private static final int ERROR_TIMEOUT_MULTIPLIER = 10;
    private static final Set<String> INVALID_TOKENS = Set.of("'if'", "'while'", "'foreach'", "'worker'");

    public GetErrorMessageTrial(TrialTreeParser parentParser) {
        super(parentParser);
    }

    @Override
    public Collection<Node> parse(String source) throws ParserTrialFailedException {
        ExecutorService executor = Executors.newFixedThreadPool(1);
        Future<?> future = executor.submit(() -> this.processSource(source));
        executor.shutdown();
        try {
            future.get(this.getTimeOutDurationMs(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new ParserTrialFailedException("Tree parsing was interrupted.");
        }
        catch (ExecutionException e) {
            String errorMessage = e.getCause().getMessage();
            if (errorMessage.startsWith("error:")) {
                throw new ParserTrialFailedException("syntax " + errorMessage);
            }
            throw new ParserTrialFailedException("syntax error: " + errorMessage);
        }
        catch (TimeoutException e) {
            future.cancel(true);
            throw new ParserTrialFailedException("Tree parsing was timed out.");
        }
        throw new IllegalStateException("Unknown statement");
    }

    private void processSource(String source) {
        try {
            TextDocument document = TextDocuments.from((String)source);
            SyntaxTree tree = SyntaxTree.from((TextDocument)document);
            ModulePartNode node = (ModulePartNode)tree.rootNode();
            NodeList members = node.members();
            block2: for (Node member : members) {
                for (Diagnostic diagnostic : member.diagnostics()) {
                    if (diagnostic.diagnosticInfo().code().equals("BCE0600") && INVALID_TOKENS.contains(diagnostic.message().split(" ")[2])) {
                        FunctionBodyBlockNode functionBodyBlockNode = NodeParser.parseFunctionBodyBlock((String)("{" + member.toSourceCode() + "}"));
                        if (!functionBodyBlockNode.hasDiagnostics()) continue block2;
                        for (Diagnostic bodyBlockDiagnostic : functionBodyBlockNode.diagnostics()) {
                            DiagnosticInfo diagnosticInfo = bodyBlockDiagnostic.diagnosticInfo();
                            if (diagnosticInfo.severity() != DiagnosticSeverity.ERROR) continue;
                            throw new ParserTrialFailedException(tree.textDocument(), bodyBlockDiagnostic);
                        }
                        continue;
                    }
                    for (Diagnostic treeDiagnostic : tree.diagnostics()) {
                        if (treeDiagnostic.diagnosticInfo().severity() != DiagnosticSeverity.ERROR) continue;
                        throw new ParserTrialFailedException(tree.textDocument(), treeDiagnostic);
                    }
                }
            }
        }
        catch (ParserTrialFailedException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    protected long getTimeOutDurationMs() {
        return super.getTimeOutDurationMs() * 10L;
    }
}

