/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.parser.trials;

import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.ExpressionStatementNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.shell.parser.TrialTreeParser;
import io.ballerina.shell.parser.trials.ParserTrialFailedException;
import io.ballerina.shell.parser.trials.TreeParserTrial;
import java.util.ArrayList;
import java.util.Collection;

public class StatementTrial
extends TreeParserTrial {
    public StatementTrial(TrialTreeParser parentParser) {
        super(parentParser);
    }

    @Override
    public Collection<Node> parse(String source) throws ParserTrialFailedException {
        BlockStatementNode blockStatementNode;
        ArrayList<Node> finalNodes;
        block5: {
            finalNodes = new ArrayList<Node>();
            try {
                blockStatementNode = NodeParser.parseBlockStatement((String)("{" + source + "}"));
                if (blockStatementNode.hasDiagnostics()) {
                    throw new ParserTrialFailedException("Error occurred during parsing as a statement");
                }
            }
            catch (ParserTrialFailedException e) {
                blockStatementNode = NodeParser.parseBlockStatement((String)("{" + source + ";}"));
                if (!blockStatementNode.hasDiagnostics()) break block5;
                throw new ParserTrialFailedException("Error occurred during parsing as a statement");
            }
        }
        NodeList statementNodes = blockStatementNode.statements();
        for (Node node : statementNodes) {
            if (node.kind() == SyntaxKind.CALL_STATEMENT) {
                node = ((ExpressionStatementNode)node).expression();
            }
            finalNodes.add(node);
        }
        return finalNodes;
    }
}

