/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.snippet;

import io.ballerina.shell.snippet.SnippetKind;

public enum SnippetSubKind {
    IMPORT_DECLARATION(SnippetKind.IMPORT_DECLARATION),
    VARIABLE_DECLARATION(SnippetKind.VARIABLE_DECLARATION),
    FUNCTION_DEFINITION(SnippetKind.MODULE_MEMBER_DECLARATION),
    LISTENER_DECLARATION(SnippetKind.MODULE_MEMBER_DECLARATION),
    TYPE_DEFINITION(SnippetKind.MODULE_MEMBER_DECLARATION),
    SERVICE_DECLARATION(SnippetKind.MODULE_MEMBER_DECLARATION, "Services are not allowed within REPL."),
    CONSTANT_DECLARATION(SnippetKind.MODULE_MEMBER_DECLARATION),
    MODULE_VARIABLE_DECLARATION(SnippetKind.MODULE_MEMBER_DECLARATION, true),
    ANNOTATION_DECLARATION(SnippetKind.MODULE_MEMBER_DECLARATION),
    MODULE_XML_NAMESPACE_DECLARATION(SnippetKind.MODULE_MEMBER_DECLARATION),
    ENUM_DECLARATION(SnippetKind.MODULE_MEMBER_DECLARATION),
    CLASS_DEFINITION(SnippetKind.MODULE_MEMBER_DECLARATION),
    ASSIGNMENT_STATEMENT(SnippetKind.STATEMENT),
    COMPOUND_ASSIGNMENT_STATEMENT(SnippetKind.STATEMENT),
    VARIABLE_DECLARATION_STATEMENT(SnippetKind.STATEMENT, true),
    BLOCK_STATEMENT(SnippetKind.STATEMENT),
    BREAK_STATEMENT(SnippetKind.STATEMENT),
    FAIL_STATEMENT(SnippetKind.STATEMENT),
    EXPRESSION_STATEMENT(SnippetKind.STATEMENT, true),
    CONTINUE_STATEMENT(SnippetKind.STATEMENT),
    IF_ELSE_STATEMENT(SnippetKind.STATEMENT),
    WHILE_STATEMENT(SnippetKind.STATEMENT),
    PANIC_STATEMENT(SnippetKind.STATEMENT),
    RETURN_STATEMENT(SnippetKind.STATEMENT),
    LOCAL_TYPE_DEFINITION_STATEMENT(SnippetKind.STATEMENT, true),
    LOCK_STATEMENT(SnippetKind.STATEMENT),
    FORK_STATEMENT(SnippetKind.STATEMENT),
    FOR_EACH_STATEMENT(SnippetKind.STATEMENT),
    XML_NAMESPACE_DECLARATION_STATEMENT(SnippetKind.STATEMENT, true),
    TRANSACTION_STATEMENT(SnippetKind.STATEMENT),
    ROLLBACK_STATEMENT(SnippetKind.STATEMENT),
    RETRY_STATEMENT(SnippetKind.STATEMENT),
    MATCH_STATEMENT(SnippetKind.STATEMENT),
    DO_STATEMENT(SnippetKind.STATEMENT),
    EXPRESSION(SnippetKind.EXPRESSION);

    private final SnippetKind kind;
    private final boolean isIgnored;
    private final String error;

    private SnippetSubKind(SnippetKind kind) {
        this.kind = kind;
        this.isIgnored = false;
        this.error = null;
    }

    private SnippetSubKind(SnippetKind kind, boolean isIgnored) {
        this.kind = kind;
        this.isIgnored = isIgnored;
        this.error = null;
    }

    private SnippetSubKind(SnippetKind kind, String error) {
        this.kind = kind;
        this.isIgnored = false;
        this.error = error;
    }

    public SnippetKind getKind() {
        return this.kind;
    }

    public boolean isValid() {
        return !this.isIgnored;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public String getError() {
        return this.error;
    }
}

