/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.snippet.types;

import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.ConstantDeclarationNode;
import io.ballerina.compiler.syntax.tree.EnumDeclarationNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ListenerDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModuleXMLNamespaceDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.shell.snippet.SnippetSubKind;
import io.ballerina.shell.snippet.types.AbstractSnippet;
import io.ballerina.shell.snippet.types.TopLevelDeclarationSnippet;
import io.ballerina.shell.utils.Identifier;
import java.util.concurrent.atomic.AtomicInteger;

public class ModuleMemberDeclarationSnippet
extends AbstractSnippet<ModuleMemberDeclarationNode>
implements TopLevelDeclarationSnippet {
    private static final AtomicInteger unnamedModuleNameIndex = new AtomicInteger(0);

    public ModuleMemberDeclarationSnippet(SnippetSubKind subKind, ModuleMemberDeclarationNode rootNode) {
        super(subKind, rootNode);
    }

    public Identifier name() {
        Object listenerName;
        Object funcName;
        Object enumName;
        Object constName;
        Object className;
        Node node = this.rootNode;
        if (node instanceof ClassDefinitionNode) {
            ClassDefinitionNode classDefinitionNode = (ClassDefinitionNode)node;
            className = classDefinitionNode.className().text();
            return new Identifier((String)className);
        }
        className = this.rootNode;
        if (className instanceof ConstantDeclarationNode) {
            ConstantDeclarationNode constantDeclarationNode = (ConstantDeclarationNode)className;
            constName = constantDeclarationNode.variableName().text();
            return new Identifier((String)constName);
        }
        constName = this.rootNode;
        if (constName instanceof EnumDeclarationNode) {
            EnumDeclarationNode enumDeclarationNode = (EnumDeclarationNode)constName;
            enumName = enumDeclarationNode.identifier().text();
            return new Identifier((String)enumName);
        }
        enumName = this.rootNode;
        if (enumName instanceof FunctionDefinitionNode) {
            FunctionDefinitionNode functionDefinitionNode = (FunctionDefinitionNode)enumName;
            funcName = functionDefinitionNode.functionName().text();
            return new Identifier((String)funcName);
        }
        funcName = this.rootNode;
        if (funcName instanceof ListenerDeclarationNode) {
            ListenerDeclarationNode listenerDeclarationNode = (ListenerDeclarationNode)funcName;
            listenerName = listenerDeclarationNode.variableName().text();
            return new Identifier((String)listenerName);
        }
        listenerName = this.rootNode;
        if (listenerName instanceof ModuleXMLNamespaceDeclarationNode) {
            ModuleXMLNamespaceDeclarationNode namespaceNode = (ModuleXMLNamespaceDeclarationNode)listenerName;
            return namespaceNode.namespacePrefix().map(Token::text).map(Identifier::new).orElseGet(this::createAnonModuleName);
        }
        listenerName = this.rootNode;
        if (listenerName instanceof TypeDefinitionNode) {
            TypeDefinitionNode typeDefinitionNode = (TypeDefinitionNode)listenerName;
            String typeName = typeDefinitionNode.typeName().text();
            return new Identifier(typeName);
        }
        return this.createAnonModuleName();
    }

    private Identifier createAnonModuleName() {
        return new Identifier("$" + unnamedModuleNameIndex.getAndIncrement());
    }
}

