/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.utils;

import io.ballerina.shell.utils.StringUtils;
import java.util.Objects;

public class Identifier {
    private static final int ASCII_VALUE = 128;
    private final String name;

    public Identifier(String name) {
        Objects.requireNonNull(name);
        StringBuilder convertedName = new StringBuilder();
        for (char character : name.toCharArray()) {
            if (character >= '\u0080') {
                String replacement = StringUtils.convertUnicode(character);
                convertedName.append(replacement);
                continue;
            }
            convertedName.append(character);
        }
        this.name = convertedName.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Identifier that = (Identifier)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String getName() {
        return this.name;
    }

    public String getUnicodeConvertedName() {
        return StringUtils.convertUnicodeToCharacter(this.name);
    }

    public String toString() {
        return this.name;
    }
}

