/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.utils;

import io.ballerina.projects.Package;
import io.ballerina.projects.PackageDependencyScope;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.environment.Environment;
import io.ballerina.projects.environment.PackageRepository;
import io.ballerina.projects.environment.ResolutionOptions;
import io.ballerina.projects.environment.ResolutionRequest;
import io.ballerina.projects.internal.environment.BallerinaDistribution;
import io.ballerina.projects.internal.environment.DefaultEnvironment;
import io.ballerina.projects.internal.repositories.BallerinaDistributionRepository;
import io.ballerina.shell.Diagnostic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.wso2.ballerinalang.compiler.util.Names;

public class ModuleImporter {
    private final List<Package> packageList = this.getPackagesFromDistRepo();
    private static final String UNDEFINED_MODULE = "undefined module";
    private static final String LANG = "lang";
    private static final List<String> SKIPPED_LIBS = Arrays.asList("lang.annotations", "lang.__internal", "lang.query");

    public boolean isModuleInDistRepo(String module) {
        String langModule = "lang." + module;
        for (Package pkg : this.packageList) {
            if (!module.equals(pkg.packageName().value()) && !langModule.equals(pkg.packageName().value())) continue;
            return true;
        }
        return false;
    }

    public String getImportStatement(String module) {
        String importStatement = "import ";
        String langModule = "lang." + module;
        String finalStatement = null;
        for (Package pkg : this.packageList) {
            if (pkg.packageName().value().equals(module)) {
                finalStatement = importStatement + pkg.packageOrg().toString() + "/" + pkg.packageName().value();
                break;
            }
            if (!pkg.packageName().value().equals(langModule)) continue;
            finalStatement = importStatement + pkg.packageOrg().toString() + "/lang." + module;
            break;
        }
        return finalStatement;
    }

    public List<String> undefinedModules(Collection<Diagnostic> diagnostics) {
        ArrayList<String> moduleErrors = new ArrayList<String>();
        for (Diagnostic diagnostic : diagnostics) {
            if (!diagnostic.toString().contains(UNDEFINED_MODULE)) continue;
            moduleErrors.add(diagnostic.toString().split(System.lineSeparator())[0].split(" ")[3]);
        }
        return moduleErrors.stream().distinct().toList();
    }

    private List<Package> getPackagesFromDistRepo() {
        DefaultEnvironment environment = new DefaultEnvironment();
        BallerinaDistribution ballerinaDistribution = BallerinaDistribution.from((Environment)environment);
        BallerinaDistributionRepository packageRepository = ballerinaDistribution.packageRepository();
        Map pkgMap = packageRepository.getPackages();
        ArrayList packages = new ArrayList();
        pkgMap.forEach((arg_0, arg_1) -> ModuleImporter.lambda$getPackagesFromDistRepo$1((PackageRepository)packageRepository, packages, arg_0, arg_1));
        return Collections.unmodifiableList(packages);
    }

    private static /* synthetic */ void lambda$getPackagesFromDistRepo$1(PackageRepository packageRepository, List packages, String key, List value) {
        if (key.equals(Names.BALLERINA_INTERNAL_ORG.getValue())) {
            return;
        }
        value.forEach(nameEntry -> {
            String[] components = nameEntry.split(":");
            if (components.length != 2 || SKIPPED_LIBS.contains(components[0])) {
                return;
            }
            String nameComponent = components[0];
            String version = components[1];
            PackageOrg packageOrg = PackageOrg.from((String)key);
            PackageName packageName = PackageName.from((String)nameComponent);
            PackageVersion pkgVersion = PackageVersion.from((String)version);
            PackageDescriptor pkdDesc = PackageDescriptor.from((PackageOrg)packageOrg, (PackageName)packageName, (PackageVersion)pkgVersion);
            ResolutionRequest request = ResolutionRequest.from((PackageDescriptor)pkdDesc, (PackageDependencyScope)PackageDependencyScope.DEFAULT);
            Optional repoPackage = packageRepository.getPackage(request, ResolutionOptions.builder().setOffline(true).build());
            repoPackage.ifPresent(packages::add);
        });
    }
}

