/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.extension;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.flowmodelgenerator.core.AgentsGenerator;
import io.ballerina.flowmodelgenerator.extension.request.EditToolRequest;
import io.ballerina.flowmodelgenerator.extension.request.GenToolRequest;
import io.ballerina.flowmodelgenerator.extension.request.GetAllAgentsRequest;
import io.ballerina.flowmodelgenerator.extension.request.GetAllMemoryManagersRequest;
import io.ballerina.flowmodelgenerator.extension.request.GetAllModelsRequest;
import io.ballerina.flowmodelgenerator.extension.request.GetConnectorActionsRequest;
import io.ballerina.flowmodelgenerator.extension.request.GetModelsRequest;
import io.ballerina.flowmodelgenerator.extension.request.GetToolsRequest;
import io.ballerina.flowmodelgenerator.extension.response.EditToolResponse;
import io.ballerina.flowmodelgenerator.extension.response.GenToolResponse;
import io.ballerina.flowmodelgenerator.extension.response.GetAgentsResponse;
import io.ballerina.flowmodelgenerator.extension.response.GetConnectorActionsResponse;
import io.ballerina.flowmodelgenerator.extension.response.GetMemoryManagersResponse;
import io.ballerina.flowmodelgenerator.extension.response.GetModelsResponse;
import io.ballerina.flowmodelgenerator.extension.response.GetToolsResponse;
import io.ballerina.modelgenerator.commons.PackageUtil;
import io.ballerina.projects.Project;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.ballerinalang.langserver.commons.service.spi.ExtendedLanguageServerService;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.eclipse.lsp4j.jsonrpc.services.JsonSegment;
import org.eclipse.lsp4j.services.LanguageServer;

@JsonSegment(value="agentManager")
public class AgentsManagerService
implements ExtendedLanguageServerService {
    private WorkspaceManager workspaceManager;
    private static final String BALLERINAX = "ballerinax";
    private static final String AI_AGENT = "ai";

    public void init(LanguageServer langServer, WorkspaceManager workspaceManager) {
        this.workspaceManager = workspaceManager;
    }

    public Class<?> getRemoteInterface() {
        return null;
    }

    @JsonRequest
    public CompletableFuture<GetAgentsResponse> getAllAgents(GetAllAgentsRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            GetAgentsResponse response = new GetAgentsResponse();
            try {
                Optional semanticModel = PackageUtil.getSemanticModel((String)BALLERINAX, (String)AI_AGENT);
                if (semanticModel.isEmpty()) {
                    return response;
                }
                AgentsGenerator agentsGenerator = new AgentsGenerator();
                response.setAgents(agentsGenerator.getAllAgents((SemanticModel)semanticModel.get()));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<GetModelsResponse> getAllModels(GetAllModelsRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            GetModelsResponse response = new GetModelsResponse();
            try {
                Optional semanticModel = PackageUtil.getSemanticModel((String)BALLERINAX, (String)AI_AGENT);
                if (semanticModel.isEmpty()) {
                    return response;
                }
                AgentsGenerator agentsGenerator = new AgentsGenerator();
                response.setModels(agentsGenerator.getAllModels((SemanticModel)semanticModel.get()));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<GetMemoryManagersResponse> getAllMemoryManagers(GetAllMemoryManagersRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            GetMemoryManagersResponse response = new GetMemoryManagersResponse();
            try {
                Optional semanticModel = PackageUtil.getSemanticModel((String)BALLERINAX, (String)AI_AGENT);
                if (semanticModel.isEmpty()) {
                    return response;
                }
                AgentsGenerator agentsGenerator = new AgentsGenerator();
                response.setMemoryManagers(agentsGenerator.getAllMemoryManagers((SemanticModel)semanticModel.get()));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<GetModelsResponse> getModels(GetModelsRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            GetModelsResponse response = new GetModelsResponse();
            try {
                Path filePath = Path.of(request.filePath(), new String[0]);
                this.workspaceManager.loadProject(filePath);
                Optional optSemanticModel = this.workspaceManager.semanticModel(filePath);
                Optional optDocument = this.workspaceManager.document(filePath);
                if (optSemanticModel.isEmpty() || optDocument.isEmpty()) {
                    return response;
                }
                AgentsGenerator agentsGenerator = new AgentsGenerator((SemanticModel)optSemanticModel.get());
                response.setModels(agentsGenerator.getModels());
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<GetToolsResponse> getTools(GetToolsRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            GetToolsResponse response = new GetToolsResponse();
            try {
                Path filePath = Path.of(request.filePath(), new String[0]);
                this.workspaceManager.loadProject(filePath);
                Optional semanticModel = this.workspaceManager.semanticModel(filePath);
                if (semanticModel.isEmpty()) {
                    return response;
                }
                AgentsGenerator agentsGenerator = new AgentsGenerator();
                response.setTools(agentsGenerator.getTools((SemanticModel)semanticModel.get()));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<GenToolResponse> genTool(GenToolRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            GenToolResponse response = new GenToolResponse();
            try {
                Path filePath = Path.of(request.filePath(), new String[0]);
                this.workspaceManager.loadProject(filePath);
                Optional semanticModel = this.workspaceManager.semanticModel(filePath);
                if (semanticModel.isEmpty()) {
                    return response;
                }
                AgentsGenerator agentsGenerator = new AgentsGenerator((SemanticModel)semanticModel.get());
                response.setTextEdits(agentsGenerator.genTool(request.flowNode(), request.toolName(), request.connection(), request.description(), filePath, this.workspaceManager));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<GetConnectorActionsResponse> getActions(GetConnectorActionsRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            GetConnectorActionsResponse response = new GetConnectorActionsResponse();
            try {
                Path filePath = Path.of(request.filePath(), new String[0]);
                Project project = this.workspaceManager.loadProject(filePath);
                Optional semanticModel = this.workspaceManager.semanticModel(filePath);
                if (semanticModel.isEmpty()) {
                    return response;
                }
                AgentsGenerator agentsGenerator = new AgentsGenerator();
                response.setActions(agentsGenerator.getActions(request.flowNode(), filePath, project, this.workspaceManager));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<EditToolResponse> editTool(EditToolRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            EditToolResponse response = new EditToolResponse();
            try {
                Path projectPath = Path.of(request.projectPath(), new String[0]);
                Path filePath = projectPath.resolve("agents.bal");
                this.workspaceManager.loadProject(filePath);
                Optional semanticModel = this.workspaceManager.semanticModel(filePath);
                if (semanticModel.isEmpty()) {
                    return response;
                }
                AgentsGenerator agentsGenerator = new AgentsGenerator((SemanticModel)semanticModel.get());
                response.setTextEdits(agentsGenerator.editTool(request.toolName(), request.description(), projectPath));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            return response;
        });
    }
}

