/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.extension;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.flowmodelgenerator.core.ConfigVariablesManager;
import io.ballerina.flowmodelgenerator.core.model.FlowNode;
import io.ballerina.flowmodelgenerator.extension.request.ConfigVariablesGetRequest;
import io.ballerina.flowmodelgenerator.extension.request.ConfigVariablesUpdateRequest;
import io.ballerina.flowmodelgenerator.extension.response.ConfigVariablesResponse;
import io.ballerina.flowmodelgenerator.extension.response.ConfigVariablesUpdateResponse;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectKind;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.ballerinalang.langserver.commons.service.spi.ExtendedLanguageServerService;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.eclipse.lsp4j.jsonrpc.services.JsonSegment;
import org.eclipse.lsp4j.services.LanguageServer;

@JsonSegment(value="configEditor")
public class ConfigEditorService
implements ExtendedLanguageServerService {
    private static final String BAL_FILE_EXTENSION = ".bal";
    private WorkspaceManager workspaceManager;
    private Gson gson;

    public void init(LanguageServer langServer, WorkspaceManager workspaceManager) {
        this.workspaceManager = workspaceManager;
        this.gson = new Gson();
    }

    public Class<?> getRemoteInterface() {
        return null;
    }

    @JsonRequest
    public CompletableFuture<ConfigVariablesResponse> getConfigVariables(ConfigVariablesGetRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            ConfigVariablesResponse response = new ConfigVariablesResponse();
            try {
                Path projectFolder = Path.of(request.projectPath(), new String[0]);
                ArrayList<Path> filePaths = new ArrayList<Path>();
                Files.walkFileTree(projectFolder, new BallerinaFileVisitor(filePaths));
                LinkedHashMap<Document, SemanticModel> documentSemanticModelMap = new LinkedHashMap<Document, SemanticModel>();
                for (Path filePath : filePaths) {
                    this.workspaceManager.loadProject(filePath);
                    Optional document = this.workspaceManager.document(filePath);
                    Optional semanticModel = this.workspaceManager.semanticModel(filePath);
                    if (document.isEmpty() || semanticModel.isEmpty()) {
                        return response;
                    }
                    documentSemanticModelMap.put((Document)document.get(), (SemanticModel)semanticModel.get());
                }
                ConfigVariablesManager configVariablesManager = new ConfigVariablesManager();
                response.setConfigVariables(configVariablesManager.get(documentSemanticModelMap));
            }
            catch (Throwable e) {
                response.setError(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<ConfigVariablesUpdateResponse> updateConfigVariables(ConfigVariablesUpdateRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            ConfigVariablesUpdateResponse response = new ConfigVariablesUpdateResponse();
            try {
                FlowNode configVariable = (FlowNode)this.gson.fromJson(request.configVariable(), FlowNode.class);
                Path configFilePath = Path.of(request.configFilePath(), new String[0]);
                Path variableFilePath = null;
                if (this.isNew(configVariable)) {
                    variableFilePath = configFilePath;
                    this.workspaceManager.loadProject(configFilePath);
                } else {
                    String variableFileName = configVariable.codedata().lineRange().fileName();
                    Project project = this.workspaceManager.loadProject(configFilePath);
                    if (project.kind() == ProjectKind.SINGLE_FILE_PROJECT) {
                        variableFilePath = project.sourceRoot();
                    } else {
                        for (Module module : project.currentPackage().modules()) {
                            for (DocumentId documentId : module.documentIds()) {
                                Document document = module.document(documentId);
                                if (!document.name().equals(variableFileName)) continue;
                                variableFilePath = project.sourceRoot().resolve(document.syntaxTree().filePath());
                            }
                        }
                    }
                }
                if (Objects.isNull(variableFilePath)) {
                    return response;
                }
                Optional document = this.workspaceManager.document(variableFilePath);
                if (document.isEmpty()) {
                    return response;
                }
                ConfigVariablesManager configVariablesManager = new ConfigVariablesManager();
                JsonElement textEdits = configVariablesManager.update((Document)document.get(), variableFilePath, configVariable);
                response.setTextEdits(textEdits);
            }
            catch (Throwable e) {
                response.setError(e);
            }
            return response;
        });
    }

    private boolean isNew(FlowNode configVariable) {
        return configVariable.codedata().isNew() != null && configVariable.codedata().isNew() != false;
    }

    private static class BallerinaFileVisitor
    extends SimpleFileVisitor<Path> {
        private final List<Path> filePaths;

        public BallerinaFileVisitor(List<Path> filePaths) {
            this.filePaths = filePaths;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            if (file.toString().endsWith(ConfigEditorService.BAL_FILE_EXTENSION)) {
                this.filePaths.add(file);
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

