/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.extension;

import com.google.gson.Gson;
import io.ballerina.flowmodelgenerator.extension.request.CreateFilesRequest;
import io.ballerina.flowmodelgenerator.extension.response.CreateFilesResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.ballerinalang.langserver.commons.service.spi.ExtendedLanguageServerService;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.eclipse.lsp4j.jsonrpc.services.JsonSegment;
import org.eclipse.lsp4j.services.LanguageServer;

@JsonSegment(value="initializer")
public class InitializerService
implements ExtendedLanguageServerService {
    private static final String[] FILES = new String[]{"config.bal", "connections.bal", "data_mappings.bal", "functions.bal", "agents.bal", "types.bal"};

    public void init(LanguageServer langServer, WorkspaceManager workspaceManager) {
    }

    @JsonRequest
    public CompletableFuture<CreateFilesResponse> createFiles(CreateFilesRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            CreateFilesResponse response = new CreateFilesResponse();
            try {
                Path projectPath = Path.of(request.projectPath(), new String[0]);
                ArrayList<String> createdFiles = new ArrayList<String>();
                for (String file : FILES) {
                    Path filePath = projectPath.resolve(file);
                    if (Files.exists(filePath, new LinkOption[0])) continue;
                    Files.createFile(filePath, new FileAttribute[0]);
                    createdFiles.add(file);
                }
                response.setFiles(new Gson().toJsonTree(createdFiles).getAsJsonArray());
            }
            catch (Throwable e) {
                response.setError(e);
            }
            return response;
        });
    }

    public Class<?> getRemoteInterface() {
        return null;
    }
}

