/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.extension;

import io.ballerina.flowmodelgenerator.core.TypesManager;
import io.ballerina.flowmodelgenerator.core.converters.JsonToRecordMapper;
import io.ballerina.flowmodelgenerator.core.utils.FileSystemUtils;
import io.ballerina.flowmodelgenerator.extension.request.JsonToRecordRequest;
import io.ballerina.flowmodelgenerator.extension.response.JsonToRecordResponse;
import io.ballerina.projects.Document;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import org.ballerinalang.langserver.commons.service.spi.ExtendedLanguageServerService;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.eclipse.lsp4j.jsonrpc.services.JsonSegment;
import org.eclipse.lsp4j.services.LanguageServer;

@JsonSegment(value="jsonToRecordTypes")
public class JsonToRecordConverterService
implements ExtendedLanguageServerService {
    private WorkspaceManager workspaceManager;

    public void init(LanguageServer langServer, WorkspaceManager workspaceManager) {
        super.init(langServer, workspaceManager);
        this.workspaceManager = workspaceManager;
    }

    public Class<?> getRemoteInterface() {
        return this.getClass();
    }

    @JsonRequest
    public CompletableFuture<JsonToRecordResponse> convert(JsonToRecordRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            JsonToRecordResponse response = new JsonToRecordResponse();
            String jsonString = request.getJsonString();
            String recordName = request.getRecordName();
            String prefix = request.getPrefix();
            boolean isRecordTypeDesc = request.getIsRecordTypeDesc();
            boolean isClosed = request.getIsClosed();
            boolean forceFormatRecordFields = request.getForceFormatRecordFields();
            boolean isNullAsOptional = request.getIsNullAsOptional();
            try {
                Path filePath = Path.of(request.getFilePathUri(), new String[0]);
                FileSystemUtils.createFileIfNotExists((WorkspaceManager)this.workspaceManager, (Path)filePath);
                Document document = FileSystemUtils.getDocument((WorkspaceManager)this.workspaceManager, (Path)filePath);
                TypesManager typesManager = new TypesManager(document);
                JsonToRecordMapper jsonToRecordMapper = new JsonToRecordMapper(recordName, prefix, document.module().project(), document, filePath, typesManager);
                response.setTypes(jsonToRecordMapper.convert(jsonString, isRecordTypeDesc, isClosed, forceFormatRecordFields, this.workspaceManager, isNullAsOptional));
            }
            catch (Throwable e) {
                response.setError(e);
            }
            return response;
        });
    }

    public String getName() {
        return "jsonToRecordTypes";
    }
}

