/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.extension;

import io.ballerina.flowmodelgenerator.core.OpenAPIClientGenerator;
import io.ballerina.flowmodelgenerator.extension.request.OpenAPIClientDeleteRequest;
import io.ballerina.flowmodelgenerator.extension.request.OpenAPIClientGenerationRequest;
import io.ballerina.flowmodelgenerator.extension.request.OpenAPIGeneratedModulesRequest;
import io.ballerina.flowmodelgenerator.extension.response.OpenAPIClientDeleteResponse;
import io.ballerina.flowmodelgenerator.extension.response.OpenAPIClientGenerationResponse;
import io.ballerina.flowmodelgenerator.extension.response.OpenAPIGeneratedModulesResponse;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import org.ballerinalang.langserver.commons.service.spi.ExtendedLanguageServerService;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.eclipse.lsp4j.jsonrpc.services.JsonSegment;
import org.eclipse.lsp4j.services.LanguageServer;

@JsonSegment(value="openAPIService")
public class OpenAPIService
implements ExtendedLanguageServerService {
    public void init(LanguageServer langServer, WorkspaceManager workspaceManager) {
    }

    public Class<?> getRemoteInterface() {
        return null;
    }

    @JsonRequest
    public CompletableFuture<OpenAPIClientGenerationResponse> genClient(OpenAPIClientGenerationRequest req) {
        return CompletableFuture.supplyAsync(() -> {
            OpenAPIClientGenerationResponse response = new OpenAPIClientGenerationResponse();
            try {
                OpenAPIClientGenerator openAPIClientGenerator = new OpenAPIClientGenerator(Path.of(req.openApiContractPath(), new String[0]), Path.of(req.projectPath(), new String[0]));
                response.setSource(openAPIClientGenerator.genClient(req.module()));
            }
            catch (Throwable e) {
                response.setError(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<OpenAPIGeneratedModulesResponse> getModules(OpenAPIGeneratedModulesRequest req) {
        return CompletableFuture.supplyAsync(() -> {
            OpenAPIGeneratedModulesResponse response = new OpenAPIGeneratedModulesResponse();
            try {
                OpenAPIClientGenerator openAPIClientGenerator = new OpenAPIClientGenerator(null, Path.of(req.projectPath(), new String[0]));
                response.setModules(openAPIClientGenerator.getModules());
            }
            catch (Throwable e) {
                response.setError(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<OpenAPIClientDeleteResponse> deleteModule(OpenAPIClientDeleteRequest req) {
        return CompletableFuture.supplyAsync(() -> {
            OpenAPIClientDeleteResponse response = new OpenAPIClientDeleteResponse();
            try {
                OpenAPIClientGenerator openAPIClientGenerator = new OpenAPIClientGenerator(null, Path.of(req.projectPath(), new String[0]));
                response.setDeleteData(openAPIClientGenerator.deleteModule(req.module()));
            }
            catch (Throwable e) {
                response.setError(e);
            }
            return response;
        });
    }
}

