/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.extension;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.flowmodelgenerator.core.TypesManager;
import io.ballerina.flowmodelgenerator.core.model.Codedata;
import io.ballerina.flowmodelgenerator.core.model.PropertyTypeMemberInfo;
import io.ballerina.flowmodelgenerator.core.model.TypeData;
import io.ballerina.flowmodelgenerator.core.type.RecordValueGenerator;
import io.ballerina.flowmodelgenerator.core.type.TypeSymbolAnalyzerFromTypeModel;
import io.ballerina.flowmodelgenerator.core.utils.FileSystemUtils;
import io.ballerina.flowmodelgenerator.extension.request.FilePathRequest;
import io.ballerina.flowmodelgenerator.extension.request.FindTypeRequest;
import io.ballerina.flowmodelgenerator.extension.request.GetTypeRequest;
import io.ballerina.flowmodelgenerator.extension.request.MultipleTypeUpdateRequest;
import io.ballerina.flowmodelgenerator.extension.request.RecordConfigRequest;
import io.ballerina.flowmodelgenerator.extension.request.RecordValueGenerateRequest;
import io.ballerina.flowmodelgenerator.extension.request.TypeUpdateRequest;
import io.ballerina.flowmodelgenerator.extension.request.UpdatedRecordConfigRequest;
import io.ballerina.flowmodelgenerator.extension.response.MultipleTypeUpdateResponse;
import io.ballerina.flowmodelgenerator.extension.response.RecordConfigResponse;
import io.ballerina.flowmodelgenerator.extension.response.RecordValueGenerateResponse;
import io.ballerina.flowmodelgenerator.extension.response.TypeListResponse;
import io.ballerina.flowmodelgenerator.extension.response.TypeResponse;
import io.ballerina.flowmodelgenerator.extension.response.TypeUpdateResponse;
import io.ballerina.modelgenerator.commons.ModuleInfo;
import io.ballerina.modelgenerator.commons.PackageUtil;
import io.ballerina.projects.Document;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.ballerinalang.diagramutil.connector.models.connector.Type;
import org.ballerinalang.langserver.commons.service.spi.ExtendedLanguageServerService;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.eclipse.lsp4j.jsonrpc.services.JsonSegment;
import org.eclipse.lsp4j.services.LanguageServer;

@JsonSegment(value="typesManager")
public class TypesManagerService
implements ExtendedLanguageServerService {
    private WorkspaceManager workspaceManager;
    private static final ConcurrentHashMap<CacheKey, SemanticModel> semanticModelCache = new ConcurrentHashMap();

    public void init(LanguageServer langServer, WorkspaceManager workspaceManager) {
        this.workspaceManager = workspaceManager;
    }

    public Class<?> getRemoteInterface() {
        return null;
    }

    @JsonRequest
    public CompletableFuture<TypeListResponse> getTypes(FilePathRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            TypeListResponse response = new TypeListResponse();
            try {
                Path filePath = Path.of(request.filePath(), new String[0]);
                this.workspaceManager.loadProject(filePath);
                Optional document = this.workspaceManager.document(filePath);
                Optional semanticModel = this.workspaceManager.semanticModel(filePath);
                if (document.isEmpty() || semanticModel.isEmpty()) {
                    return response;
                }
                TypesManager typesManager = new TypesManager((Document)document.get());
                JsonElement allTypes = typesManager.getAllTypes((SemanticModel)semanticModel.get());
                response.setTypes(allTypes);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<TypeResponse> getType(GetTypeRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            TypeResponse response = new TypeResponse();
            try {
                Path filePath = Path.of(request.filePath(), new String[0]);
                this.workspaceManager.loadProject(filePath);
                Optional document = this.workspaceManager.document(filePath);
                Optional semanticModel = this.workspaceManager.semanticModel(filePath);
                if (document.isEmpty() || semanticModel.isEmpty()) {
                    return response;
                }
                TypesManager typesManager = new TypesManager((Document)document.get());
                JsonElement result = typesManager.getType((SemanticModel)semanticModel.get(), (Document)document.get(), request.linePosition());
                if (result == null) {
                    return response;
                }
                response.setType((JsonElement)result.getAsJsonObject().get("type").getAsJsonObject());
                response.setRefs(result.getAsJsonObject().get("refs").getAsJsonArray());
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<TypeResponse> getGraphqlType(GetTypeRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            TypeResponse response = new TypeResponse();
            try {
                Path filePath = Path.of(request.filePath(), new String[0]);
                this.workspaceManager.loadProject(filePath);
                Optional document = this.workspaceManager.document(filePath);
                Optional semanticModel = this.workspaceManager.semanticModel(filePath);
                if (document.isEmpty() || semanticModel.isEmpty()) {
                    return response;
                }
                TypesManager typesManager = new TypesManager((Document)document.get());
                JsonElement result = typesManager.getGraphqlType((SemanticModel)semanticModel.get(), (Document)document.get(), request.linePosition());
                if (result == null) {
                    return response;
                }
                response.setType((JsonElement)result.getAsJsonObject().get("type").getAsJsonObject());
                response.setRefs(result.getAsJsonObject().get("refs").getAsJsonArray());
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<TypeUpdateResponse> createGraphqlClassType(TypeUpdateRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            TypeUpdateResponse response = new TypeUpdateResponse();
            try {
                Path filePath = Path.of(request.filePath(), new String[0]);
                this.workspaceManager.loadProject(filePath);
                TypeData typeData = (TypeData)new Gson().fromJson(request.type(), TypeData.class);
                Optional document = this.workspaceManager.document(filePath);
                if (document.isEmpty()) {
                    return response;
                }
                TypesManager typesManager = new TypesManager((Document)document.get());
                response.setName(typeData.name());
                response.setTextEdits(typesManager.createGraphqlClassType(filePath, typeData));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<TypeUpdateResponse> updateType(TypeUpdateRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            TypeUpdateResponse response = new TypeUpdateResponse();
            try {
                Path filePath = Path.of(request.filePath(), new String[0]);
                FileSystemUtils.createFileIfNotExists((WorkspaceManager)this.workspaceManager, (Path)filePath);
                TypeData typeData = (TypeData)new Gson().fromJson(request.type(), TypeData.class);
                Document document = FileSystemUtils.getDocument((WorkspaceManager)this.workspaceManager, (Path)filePath);
                TypesManager typesManager = new TypesManager(document);
                response.setName(typeData.name());
                response.setTextEdits(typesManager.updateType(filePath, typeData));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<MultipleTypeUpdateResponse> updateTypes(MultipleTypeUpdateRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            MultipleTypeUpdateResponse response = new MultipleTypeUpdateResponse();
            try {
                Path filePath = Path.of(request.filePath(), new String[0]);
                FileSystemUtils.createFileIfNotExists((WorkspaceManager)this.workspaceManager, (Path)filePath);
                Document document = FileSystemUtils.getDocument((WorkspaceManager)this.workspaceManager, (Path)filePath);
                ArrayList<TypeData> typeDataList = new ArrayList<TypeData>();
                for (JsonElement element : request.types()) {
                    typeDataList.add((TypeData)new Gson().fromJson(element, TypeData.class));
                }
                TypesManager typesManager = new TypesManager(document);
                response.setTextEdits(typesManager.createMultipleTypes(filePath, typeDataList));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<RecordConfigResponse> recordConfig(RecordConfigRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            RecordConfigResponse response = new RecordConfigResponse();
            try {
                TypeSymbol tSymbol;
                Codedata codedata = request.codedata();
                String orgName = codedata.org();
                String packageName = Objects.isNull(codedata.packageName()) ? codedata.module() : codedata.packageName();
                String moduleName = codedata.module();
                String versionName = codedata.version();
                Path filePath = Path.of(request.filePath(), new String[0]);
                Optional<SemanticModel> semanticModel = this.getCachedSemanticModel(orgName, packageName, moduleName, versionName, filePath);
                if (semanticModel.isEmpty()) {
                    throw new IllegalArgumentException(String.format("Package '%s/%s:%s' not found", orgName, packageName, versionName));
                }
                String[] parts = request.typeConstraint().split(":");
                String typeStr = parts.length > 1 ? parts[1] : parts[0];
                Optional<Symbol> typeSymbol = semanticModel.get().moduleSymbols().parallelStream().filter(symbol -> symbol.kind() == SymbolKind.TYPE_DEFINITION && symbol.nameEquals(typeStr)).findFirst();
                if (typeSymbol.isEmpty()) {
                    throw new IllegalArgumentException(String.format("Type '%s' not found in package '%s/%s:%s'", request.typeConstraint(), orgName, packageName, versionName));
                }
                Symbol patt0$temp = typeSymbol.get();
                if (patt0$temp instanceof TypeSymbol && (tSymbol = (TypeSymbol)patt0$temp).typeKind() != TypeDescKind.RECORD) {
                    throw new IllegalArgumentException(String.format("Type '%s' is not a record", request.typeConstraint()));
                }
                response.setRecordConfig(Type.fromSemanticSymbol((Symbol)typeSymbol.get(), (SemanticModel)semanticModel.get()));
            }
            catch (Throwable e) {
                response.setError(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<RecordValueGenerateResponse> generateValue(RecordValueGenerateRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            RecordValueGenerateResponse response = new RecordValueGenerateResponse();
            try {
                response.setRecordValue(RecordValueGenerator.generate((JsonObject)request.type().getAsJsonObject()));
            }
            catch (Throwable e) {
                response.setError(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<RecordConfigResponse> updateRecordConfig(UpdatedRecordConfigRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            RecordConfigResponse response = new RecordConfigResponse();
            try {
                FindTypeRequest.TypePackageInfo info = FindTypeRequest.TypePackageInfo.from(request.codedata());
                SemanticModel semanticModel = this.findSemanticModel(info, request.filePath());
                Optional<Symbol> typeSymbol = this.findTypeSymbolFromSemanticModel(semanticModel, request.typeConstraint());
                if (typeSymbol.isEmpty()) {
                    throw new IllegalArgumentException(String.format("Type '%s' not found in package '%s/%s:%s'", request.typeConstraint(), info.org(), info.moduleName(), info.version()));
                }
                Type type = TypeSymbolAnalyzerFromTypeModel.analyze((Symbol)typeSymbol.get(), (String)request.expr(), (SemanticModel)semanticModel);
                response.setRecordConfig(type);
            }
            catch (Throwable e) {
                response.setError(e);
            }
            semanticModelCache.clear();
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<RecordConfigResponse> findMatchingType(FindTypeRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            RecordConfigResponse response = new RecordConfigResponse();
            try {
                String expression = request.expr();
                for (PropertyTypeMemberInfo memberInfo : request.typeMembers()) {
                    try {
                        Type type;
                        FindTypeRequest.TypePackageInfo info = FindTypeRequest.TypePackageInfo.from(memberInfo.packageInfo(), memberInfo.packageName());
                        SemanticModel semanticModel = this.findSemanticModel(info, request.filePath());
                        Optional<Symbol> typeSymbol = this.findTypeSymbolFromSemanticModel(semanticModel, memberInfo.type());
                        if (typeSymbol.isEmpty() || (type = TypeSymbolAnalyzerFromTypeModel.analyze((Symbol)typeSymbol.get(), (String)expression, (SemanticModel)semanticModel)) == null || !type.selected) continue;
                        response.setRecordConfig(type);
                        type.name = memberInfo.type();
                        response.setTypeName(memberInfo.type());
                        break;
                    }
                    catch (Throwable throwable) {
                    }
                }
            }
            catch (Throwable e) {
                response.setError(e);
            }
            semanticModelCache.clear();
            return response;
        });
    }

    private Optional<SemanticModel> getCachedSemanticModel(String org, String packageName, String moduleName, String version, Path filePath) {
        CacheKey keyWithPath = new CacheKey(org, packageName, version);
        SemanticModel cachedModel = semanticModelCache.get(keyWithPath);
        if (cachedModel != null) {
            return Optional.of(cachedModel);
        }
        Optional model = PackageUtil.getSemanticModelIfMatched((WorkspaceManager)this.workspaceManager, (Path)filePath, (String)org, (String)packageName, (String)moduleName, (String)version);
        if (model.isPresent()) {
            semanticModelCache.put(keyWithPath, (SemanticModel)model.get());
            return model;
        }
        CacheKey keyWithoutPath = new CacheKey(org, packageName, version);
        cachedModel = semanticModelCache.get(keyWithoutPath);
        if (cachedModel != null) {
            return Optional.of(cachedModel);
        }
        ModuleInfo moduleInfo = new ModuleInfo(org, packageName, moduleName, version);
        model = PackageUtil.getSemanticModel((ModuleInfo)moduleInfo);
        model.ifPresent(m -> semanticModelCache.put(keyWithoutPath, (SemanticModel)m));
        return model;
    }

    private SemanticModel findSemanticModel(FindTypeRequest.TypePackageInfo packageInfo, String path) {
        Path filePath;
        String versionName;
        String moduleName;
        String packageName;
        String orgName = packageInfo.org();
        Optional<SemanticModel> semanticModel = this.getCachedSemanticModel(orgName, packageName = packageInfo.packageName(), moduleName = packageInfo.moduleName(), versionName = packageInfo.version(), filePath = Path.of(path, new String[0]));
        if (semanticModel.isEmpty()) {
            throw new IllegalArgumentException(String.format("Package '%s/%s:%s' not found", orgName, packageName, versionName));
        }
        return semanticModel.get();
    }

    private Optional<Symbol> findTypeSymbolFromSemanticModel(SemanticModel semanticModel, String typeConstraint) {
        String[] parts = typeConstraint.split(":");
        String type = parts.length > 1 ? parts[1] : parts[0];
        return semanticModel.moduleSymbols().parallelStream().filter(symbol -> symbol.kind() == SymbolKind.TYPE_DEFINITION && symbol.nameEquals(type)).findFirst();
    }

    private record CacheKey(String org, String packageName, String version) {
    }

    private record PackageNameModulePartName(String packageName, String modulePartName) {
        public static PackageNameModulePartName from(String packageNameStr) {
            String[] parts = packageNameStr.split("\\.");
            if (parts.length > 1) {
                return new PackageNameModulePartName(parts[0], parts[1]);
            }
            if (parts.length == 1) {
                return new PackageNameModulePartName(parts[0], null);
            }
            return new PackageNameModulePartName(null, null);
        }
    }
}

