/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.graphql.exception;

import io.ballerina.graphql.cmd.DiagnosticMessages;
import io.ballerina.graphql.cmd.GraphqlDiagnostic;
import io.ballerina.graphql.cmd.Utils;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextRange;

public class ValidationException
extends Exception {
    private String message;
    private String projectName;

    public ValidationException(String message, Throwable e) {
        super(message, e);
        this.message = message;
    }

    public ValidationException(String message) {
        super(message);
        this.message = message;
    }

    public ValidationException(String message, String projectName) {
        super(message);
        this.message = message;
        this.projectName = projectName;
    }

    @Override
    public String getMessage() {
        if (this.projectName != null) {
            Location location = new Location(){

                public LineRange lineRange() {
                    LinePosition from = LinePosition.from((int)0, (int)0);
                    return LineRange.from((String)("(" + ValidationException.this.projectName + ":)"), (LinePosition)from, (LinePosition)from);
                }

                public TextRange textRange() {
                    return TextRange.from((int)0, (int)0);
                }
            };
            GraphqlDiagnostic graphqlDiagnostic = Utils.constructGraphqlDiagnostic(DiagnosticMessages.GRAPHQL_CLI_102.getCode(), this.message + "\nPlease check project : " + this.projectName, DiagnosticSeverity.ERROR, location, new Object[0]);
            return graphqlDiagnostic.toString();
        }
        return this.message;
    }
}

