/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.graphql.validator;

import io.ballerina.graphql.cmd.Utils;
import io.ballerina.graphql.cmd.pojo.Config;
import io.ballerina.graphql.cmd.pojo.Project;
import io.ballerina.graphql.exception.DocumentPathValidationException;
import io.ballerina.graphql.exception.SchemaPathValidationException;
import io.ballerina.graphql.exception.SchemaUrlValidationException;
import io.ballerina.graphql.exception.ValidationException;
import io.ballerina.graphql.generator.client.GraphqlClientProject;
import io.ballerina.graphql.generator.client.pojo.Extension;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ConfigValidator {
    private static ConfigValidator configValidator = null;
    private List<GraphqlClientProject> projects = new ArrayList<GraphqlClientProject>();

    public static ConfigValidator getInstance() {
        if (configValidator == null) {
            configValidator = new ConfigValidator();
        }
        return configValidator;
    }

    public void validate(Config config) throws ValidationException, IOException {
        this.populateProjects(config);
        for (GraphqlClientProject project : this.projects) {
            this.validateProject(project);
        }
    }

    private void populateProjects(Config config) throws ValidationException {
        String schema = config.getSchema();
        List<String> documents = config.getDocuments();
        Extension extensions = config.getExtensions();
        Map<String, Project> projects = config.getProjects();
        if (schema != null || documents != null || extensions != null) {
            this.projects.add(new GraphqlClientProject("root", schema, documents, extensions));
        }
        if (projects != null) {
            for (String projectName : projects.keySet()) {
                if (projects.get(projectName) == null) {
                    throw new ValidationException("The GraphQL configuration YAML file is configured with an empty project. \nPlease provide a valid project content in the YAML file.", projectName);
                }
                this.projects.add(new GraphqlClientProject(projectName, projects.get(projectName).getSchema(), projects.get(projectName).getDocuments(), projects.get(projectName).getExtensions()));
            }
        }
    }

    private void validateProject(GraphqlClientProject project) throws ValidationException, IOException {
        String schema = project.getSchema();
        List documents = project.getDocuments();
        if (schema == null || documents == null) {
            throw new ValidationException("The GraphQL configuration YAML file project is configured with a missing schema or documents section. \nPlease provide both the schema & documents section under each project in the YAML file.", project.getName());
        }
        try {
            this.validateSchema(schema);
            this.validateDocuments(documents);
        }
        catch (DocumentPathValidationException | SchemaPathValidationException | SchemaUrlValidationException e) {
            throw new ValidationException(e.getMessage(), project.getName());
        }
    }

    private void validateSchema(String schema) throws SchemaUrlValidationException, SchemaPathValidationException, IOException {
        if (schema.startsWith("http")) {
            this.validateSchemaUrl(schema);
        }
        if (!schema.startsWith("http")) {
            File schemaFile = new File(schema);
            Path schemaPath = Paths.get(schemaFile.getCanonicalPath(), new String[0]);
            ConfigValidator.validateSchemaPath(schemaPath);
        }
    }

    private void validateDocuments(List<String> documents) throws DocumentPathValidationException, IOException {
        for (String document : documents) {
            File documentFile = new File(document);
            Path documentPath = Paths.get(documentFile.getCanonicalPath(), new String[0]);
            ConfigValidator.validateDocumentPath(documentPath);
        }
    }

    private void validateSchemaUrl(String schema) throws SchemaUrlValidationException {
        if (!Utils.isValidURL(schema)) {
            throw new SchemaUrlValidationException("The GraphQL configuration YAML file project is configured with an invalid web URL for schema location. \nPlease provide a valid graphQL endpoint URL or file path for the schema section under each project in the YAML file. \nInvalid URL " + schema);
        }
    }

    private static void validateSchemaPath(Path schemaPath) throws SchemaPathValidationException {
        if (!Files.exists(schemaPath, new LinkOption[0])) {
            throw new SchemaPathValidationException("The GraphQL configuration YAML file project is configured with a file path for schema location which does not exist. \nPlease provide a valid graphQL endpoint URL or file path for the schema section under each project in the YAML file. \nInvalid file path " + String.valueOf(schemaPath));
        }
    }

    private static void validateDocumentPath(Path documentPath) throws DocumentPathValidationException {
        if (!Files.exists(documentPath, new LinkOption[0])) {
            throw new DocumentPathValidationException("The GraphQL configuration YAML file project is configured with a file path for queries file location which does not exist. \nPlease provide a valid file path for the schema section under each project in the YAML file. \nInvalid file path " + String.valueOf(documentPath));
        }
    }
}

