/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.commons.types;

import io.ballerina.stdlib.graphql.commons.types.Directive;
import io.ballerina.stdlib.graphql.commons.types.FederatedDirective;
import io.ballerina.stdlib.graphql.commons.types.FederatedEnumValue;
import io.ballerina.stdlib.graphql.commons.types.Field;
import io.ballerina.stdlib.graphql.commons.types.InputValue;
import io.ballerina.stdlib.graphql.commons.types.ObjectKind;
import io.ballerina.stdlib.graphql.commons.types.Position;
import io.ballerina.stdlib.graphql.commons.types.ScalarType;
import io.ballerina.stdlib.graphql.commons.types.Type;
import io.ballerina.stdlib.graphql.commons.types.TypeKind;
import io.ballerina.stdlib.graphql.commons.types.TypeName;
import io.ballerina.stdlib.graphql.commons.utils.KeyDirectivesArgumentHolder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Schema
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String description;
    private final Map<String, Type> types;
    private final List<Directive> directives;
    private Type queryType;
    private Type mutationType = null;
    private Type subscriptionType = null;
    private final boolean isSubgraph;
    private final List<Type> entities;
    private final Map<String, KeyDirectivesArgumentHolder> entityKeyDirectiveArgumentHolders = new HashMap<String, KeyDirectivesArgumentHolder>();
    private static final String REPRESENTATIONS_ARGUMENT = "representations";
    private static final String SDL_FIELD = "sdl";
    public static final String SERVICE_RESOLVER_NAME = "_service";
    public static final String ENTITIES_RESOLVER_NAME = "_entities";

    public Schema(String description, boolean isSubgraph) {
        this.description = description;
        this.types = new LinkedHashMap<String, Type>();
        this.directives = new ArrayList<Directive>();
        this.entities = new ArrayList<Type>();
        this.isSubgraph = isSubgraph;
    }

    public void addEntityKeyDirectiveArguments(String entityName, KeyDirectivesArgumentHolder argumentHolder) {
        this.entityKeyDirectiveArgumentHolders.put(entityName, argumentHolder);
    }

    public Map<String, KeyDirectivesArgumentHolder> getEntityKeyDirectiveArgumentHolders() {
        return this.entityKeyDirectiveArgumentHolders;
    }

    public Type addType(String typeName, TypeKind kind, String description) {
        if (this.types.containsKey(typeName)) {
            return this.types.get(typeName);
        }
        Type type = new Type(typeName, kind, description);
        this.types.put(typeName, type);
        return type;
    }

    public Type addType(String typeName, TypeKind kind, String description, Position position) {
        if (this.types.containsKey(typeName)) {
            return this.types.get(typeName);
        }
        Type type = new Type(typeName, kind, description, position);
        this.types.put(typeName, type);
        return type;
    }

    public Type addType(String typeName, TypeKind kind, String description, Position position, ObjectKind objectKind) {
        if (this.types.containsKey(typeName)) {
            return this.types.get(typeName);
        }
        Type type = new Type(typeName, kind, description, position, objectKind);
        this.types.put(typeName, type);
        return type;
    }

    public Type addType(ScalarType scalarType) {
        if (this.types.containsKey(scalarType.getName())) {
            return this.types.get(scalarType.getName());
        }
        Type type = new Type(scalarType.getName(), TypeKind.SCALAR, scalarType.getDescription());
        this.types.put(scalarType.getName(), type);
        return type;
    }

    public boolean containsType(String name) {
        return this.types.containsKey(name);
    }

    public Map<String, Type> getTypes() {
        return this.types;
    }

    public Type getType(String name) {
        return this.types.get(name);
    }

    public String getDescription() {
        return this.description;
    }

    public Type getQueryType() {
        return this.queryType;
    }

    public void setQueryType(Type type) {
        this.queryType = type;
    }

    public void setMutationType(Type type) {
        this.mutationType = type;
    }

    public Type getMutationType() {
        return this.mutationType;
    }

    public void setSubscriptionType(Type type) {
        this.subscriptionType = type;
    }

    public Type getSubscriptionType() {
        return this.subscriptionType;
    }

    public void addDirective(Directive directive) {
        this.directives.add(directive);
    }

    public void addDirective(FederatedDirective directive) {
        this.directives.add(new Directive(directive));
    }

    public List<Directive> getDirectives() {
        return this.directives;
    }

    public void addEntity(Type federatedEntities) {
        if (!this.isSubgraph()) {
            return;
        }
        this.entities.add(federatedEntities);
    }

    public List<Type> getEntities() {
        return this.entities;
    }

    public void addSubgraphSchemaAdditions() {
        if (!this.isSubgraph()) {
            return;
        }
        ScalarType.getFederatedScalarTypes().forEach(this::addType);
        Arrays.stream(FederatedEnumValue.values()).forEach(enumType -> this.types.put(enumType.getName(), enumType.getEnumTypeWithValues()));
        Arrays.stream(FederatedDirective.values()).forEach(this::addDirective);
        this.addFederatedServiceTypeWithResolver();
        this.addFederatedEntitiesWithResolver();
    }

    private void addFederatedServiceTypeWithResolver() {
        Type service = this.addType(TypeName.SERVICE.getName(), TypeKind.OBJECT, null);
        Type nonNullableString = new Type(TypeKind.NON_NULL, this.getType(TypeName.STRING.getName()));
        service.addField(new Field(SDL_FIELD, nonNullableString));
        Field serviceField = new Field(SERVICE_RESOLVER_NAME, new Type(TypeKind.NON_NULL, service));
        Type query = this.getQueryType();
        query.addField(serviceField);
    }

    private void addFederatedEntitiesWithResolver() {
        if (this.entities.size() == 0) {
            return;
        }
        Type entity = this.addType(TypeName.ENTITY.getName(), TypeKind.UNION, null);
        this.getEntities().forEach(entity::addPossibleType);
        Field entities = new Field(ENTITIES_RESOLVER_NAME, new Type(TypeKind.NON_NULL, new Type(TypeKind.LIST, entity)));
        Type nonNullableAnyScalar = new Type(TypeKind.NON_NULL, this.getType(TypeName.ANY.getName()));
        Type nonNullableListOfAny = new Type(TypeKind.NON_NULL, new Type(TypeKind.LIST, nonNullableAnyScalar));
        entities.addArg(new InputValue(REPRESENTATIONS_ARGUMENT, nonNullableListOfAny, null, null));
        Type query = this.getQueryType();
        query.addField(entities);
    }

    public boolean isSubgraph() {
        return this.isSubgraph;
    }
}

