/*
 * Decompiled with CFR 0.152.
 */
package org.dataloader.stats;

import org.dataloader.impl.Assertions;
import org.dataloader.stats.SimpleStatisticsCollector;
import org.dataloader.stats.Statistics;
import org.dataloader.stats.StatisticsCollector;
import org.dataloader.stats.context.IncrementBatchLoadCountByStatisticsContext;
import org.dataloader.stats.context.IncrementBatchLoadExceptionCountStatisticsContext;
import org.dataloader.stats.context.IncrementCacheHitCountStatisticsContext;
import org.dataloader.stats.context.IncrementLoadCountStatisticsContext;
import org.dataloader.stats.context.IncrementLoadErrorCountStatisticsContext;

public class DelegatingStatisticsCollector
implements StatisticsCollector {
    private final StatisticsCollector collector = new SimpleStatisticsCollector();
    private final StatisticsCollector delegateCollector;

    public DelegatingStatisticsCollector(StatisticsCollector delegateCollector) {
        this.delegateCollector = Assertions.nonNull(delegateCollector);
    }

    @Override
    public <K> long incrementLoadCount(IncrementLoadCountStatisticsContext<K> context) {
        this.delegateCollector.incrementLoadCount(context);
        return this.collector.incrementLoadCount(context);
    }

    @Override
    @Deprecated
    public long incrementLoadCount() {
        return this.incrementLoadCount(null);
    }

    @Override
    public <K> long incrementLoadErrorCount(IncrementLoadErrorCountStatisticsContext<K> context) {
        this.delegateCollector.incrementLoadErrorCount(context);
        return this.collector.incrementLoadErrorCount(context);
    }

    @Override
    @Deprecated
    public long incrementLoadErrorCount() {
        return this.incrementLoadErrorCount(null);
    }

    @Override
    public <K> long incrementBatchLoadCountBy(long delta, IncrementBatchLoadCountByStatisticsContext<K> context) {
        this.delegateCollector.incrementBatchLoadCountBy(delta, context);
        return this.collector.incrementBatchLoadCountBy(delta, context);
    }

    @Override
    @Deprecated
    public long incrementBatchLoadCountBy(long delta) {
        return this.incrementBatchLoadCountBy(delta, null);
    }

    @Override
    public <K> long incrementBatchLoadExceptionCount(IncrementBatchLoadExceptionCountStatisticsContext<K> context) {
        this.delegateCollector.incrementBatchLoadExceptionCount(context);
        return this.collector.incrementBatchLoadExceptionCount(context);
    }

    @Override
    @Deprecated
    public long incrementBatchLoadExceptionCount() {
        return this.incrementBatchLoadExceptionCount(null);
    }

    @Override
    public <K> long incrementCacheHitCount(IncrementCacheHitCountStatisticsContext<K> context) {
        this.delegateCollector.incrementCacheHitCount(context);
        return this.collector.incrementCacheHitCount(context);
    }

    @Override
    @Deprecated
    public long incrementCacheHitCount() {
        return this.incrementCacheHitCount(null);
    }

    @Override
    public Statistics getStatistics() {
        return this.collector.getStatistics();
    }

    public Statistics getDelegateStatistics() {
        return this.delegateCollector.getStatistics();
    }
}

