/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.validator;

import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.ListConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeLocation;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.openapi.validator.Validator;
import io.ballerina.openapi.validator.ValidatorUtils;
import io.ballerina.openapi.validator.error.CompilationError;
import io.ballerina.openapi.validator.model.Filter;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Package;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class PreValidator
implements Validator {
    private Filter filter;
    private SyntaxNodeAnalysisContext context;
    private OpenAPI openAPI;

    public void initialize(SyntaxNodeAnalysisContext context) {
        this.context = context;
        this.openAPI = null;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public OpenAPI getOpenAPI() {
        return this.openAPI;
    }

    @Override
    public void validate() {
        boolean erroneousCompilation = this.context.compilation().diagnosticResult().diagnostics().stream().anyMatch(d -> DiagnosticSeverity.ERROR == d.diagnosticInfo().severity());
        if (erroneousCompilation) {
            return;
        }
        ServiceDeclarationNode serviceNode = (ServiceDeclarationNode)this.context.node();
        NodeLocation location = serviceNode.location();
        if (!ValidatorUtils.isHttpService(serviceNode, this.context.semanticModel())) {
            ValidatorUtils.reportDiagnostic(this.context, CompilationError.NON_HTTP_SERVICE, (Location)location, DiagnosticSeverity.WARNING, new Object[0]);
            return;
        }
        Optional metadata = serviceNode.metadata();
        boolean validatorEnable = false;
        if (metadata.isEmpty()) {
            return;
        }
        MetadataNode serviceMetadata = (MetadataNode)metadata.orElseThrow();
        NodeList annotations = serviceMetadata.annotations();
        if (annotations.isEmpty()) {
            return;
        }
        for (AnnotationNode annotation : annotations) {
            Node node = annotation.annotReference();
            if (node.toString().trim().equals("openapi:ServiceInfo")) {
                boolean isEmbed;
                SeparatedNodeList<MappingFieldNode> fields = this.extractAnnotationAttributeList(annotation);
                if (fields == null) {
                    return;
                }
                boolean bl = isEmbed = fields.size() == 1 && ((SpecificFieldNode)fields.get(0)).fieldName().toString().trim().equals("embed");
                if (isEmbed) {
                    return;
                }
                Filter.FilterBuilder filterBuilder = new Filter.FilterBuilder();
                for (MappingFieldNode field : fields) {
                    Node fieldName;
                    String attributeName;
                    if (!(field instanceof SpecificFieldNode)) {
                        return;
                    }
                    SpecificFieldNode specificField = (SpecificFieldNode)field;
                    Optional expressionNode = specificField.valueExpr();
                    if (expressionNode.isEmpty()) {
                        return;
                    }
                    ExpressionNode expression = (ExpressionNode)expressionNode.get();
                    List<Object> values = new ArrayList();
                    if (expression instanceof ListConstructorExpressionNode) {
                        ListConstructorExpressionNode list = (ListConstructorExpressionNode)expression;
                        values = PreValidator.setFilters(list);
                    }
                    if (!(attributeName = ((Token)(fieldName = specificField.fieldName())).text()).equals("contract") && !attributeName.equals("failOnErrors") && values.isEmpty()) continue;
                    switch (attributeName) {
                        case "contract": {
                            Path openAPIPath = Paths.get(expression.toString().replaceAll("\"", "").trim(), new String[0]);
                            Path ballerinaFilePath = this.getBallerinaFilePath();
                            this.openAPI = this.getOpenAPIContract(ballerinaFilePath, (Location)location, openAPIPath);
                            if (this.openAPI == null) break;
                            validatorEnable = true;
                            break;
                        }
                        case "failOnErrors": {
                            if (expression.toString().contains("true")) {
                                filterBuilder.withKind(DiagnosticSeverity.ERROR);
                                break;
                            }
                            filterBuilder.withKind(DiagnosticSeverity.WARNING);
                            break;
                        }
                        case "tags": {
                            filterBuilder.withTag(values);
                            break;
                        }
                        case "operations": {
                            filterBuilder.withOperation(values);
                            break;
                        }
                        case "excludeTags": {
                            filterBuilder.withExcludeTag(values);
                            break;
                        }
                        case "excludeOperations": {
                            filterBuilder.withExcludeOperation(values);
                            break;
                        }
                    }
                }
                this.filter = filterBuilder.build();
            }
            if (!validatorEnable) continue;
            break;
        }
    }

    private SeparatedNodeList<MappingFieldNode> extractAnnotationAttributeList(AnnotationNode annotation) {
        Optional mappingNode = annotation.annotValue();
        if (mappingNode.isEmpty()) {
            return null;
        }
        MappingConstructorExpressionNode exprNode = (MappingConstructorExpressionNode)mappingNode.get();
        SeparatedNodeList fields = exprNode.fields();
        if (fields.isEmpty()) {
            return null;
        }
        return fields;
    }

    private Path getBallerinaFilePath() {
        Package aPackage = this.context.currentPackage();
        DocumentId documentId = this.context.documentId();
        Optional path = aPackage.project().documentPath(documentId);
        return path.orElse(null);
    }

    private OpenAPI getOpenAPIContract(Path ballerinaFilePath, Location location, Path openAPIPath) {
        Path relativePath = null;
        try {
            if (openAPIPath.toString().isBlank()) {
                ValidatorUtils.reportDiagnostic(this.context, CompilationError.EMPTY_CONTRACT_PATH, location, DiagnosticSeverity.WARNING, new Object[0]);
            } else if (Paths.get(openAPIPath.toString(), new String[0]).isAbsolute()) {
                relativePath = Paths.get(openAPIPath.toString(), new String[0]);
            } else {
                File file = new File(ballerinaFilePath.toString());
                File parentFolder = new File(file.getParent());
                File openapiContract = new File(parentFolder, openAPIPath.toString());
                relativePath = Paths.get(openapiContract.getCanonicalPath(), new String[0]);
            }
            if (relativePath != null) {
                return ValidatorUtils.parseOpenAPIFile(this.context, relativePath.toString(), location);
            }
        }
        catch (IOException e) {
            ValidatorUtils.reportDiagnostic(this.context, CompilationError.UNEXPECTED_EXCEPTIONS, location, DiagnosticSeverity.ERROR, e.getMessage());
        }
        return null;
    }

    private static List<String> setFilters(ListConstructorExpressionNode list) {
        SeparatedNodeList expressions = list.expressions();
        Iterator iterator = expressions.iterator();
        ArrayList<String> values = new ArrayList<String>();
        while (iterator.hasNext()) {
            Node item = (Node)iterator.next();
            if (item.kind() != SyntaxKind.STRING_LITERAL || item.toString().isBlank()) continue;
            Token stringItem = ((BasicLiteralNode)item).literalToken();
            String text = stringItem.text();
            text = text.length() > 1 && text.charAt(0) == '\"' && text.charAt(text.length() - 1) == '\"' ? text.substring(1, text.length() - 1) : text.substring(1);
            values.add(text);
        }
        return values;
    }
}

