/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.validator.diagnostic;

import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;

public enum OpenAPIDiagnosticCodes {
    OPENAPI_100("OPENAPI_100", "OpenAPI example annotation is not supported on non-anydata types", DiagnosticSeverity.ERROR),
    OPENAPI_101("OPENAPI_101", "OpenAPI examples annotation is not supported on non-anydata types", DiagnosticSeverity.ERROR),
    OPENAPI_102("OPENAPI_102", "OpenAPI example and OpenAPI examples annotations cannot be used together", DiagnosticSeverity.ERROR),
    OPENAPI_103("OPENAPI_103", "OpenAPI example(s) annotation is not supported on rest parameter", DiagnosticSeverity.ERROR),
    OPENAPI_104("OPENAPI_104", "OpenAPI example annotation is not allowed for resource function implemented via the 'http:ServiceContract' type. The HTTP annotations are inferred from the service contract type", DiagnosticSeverity.ERROR),
    OPENAPI_105("OPENAPI_105", "OpenAPI examples annotation is not allowed for resource function implemented via the 'http:ServiceContract' type. The HTTP annotations are inferred from the service contract type", DiagnosticSeverity.ERROR);

    private final String code;
    private final String message;
    private final DiagnosticSeverity severity;

    private OpenAPIDiagnosticCodes(String code, String message, DiagnosticSeverity severity) {
        this.code = code;
        this.message = message;
        this.severity = severity;
    }

    public Diagnostic getDiagnosticCode(Location location) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(this.code, this.message, this.severity);
        return DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)location, (Object[])new Object[0]);
    }

    public Diagnostic getDiagnosticCode(Location location, Object ... args) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(this.code, this.message, this.severity);
        return DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)location, (Object[])args);
    }
}

