/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api;

import io.ballerina.stdlib.http.api.HttpResource;
import io.ballerina.stdlib.http.api.HttpService;
import java.util.Collections;
import java.util.List;

public abstract class HttpOASResource
extends HttpResource {
    protected static final String RESOURCE_METHOD = "$get$";

    protected HttpOASResource(HttpService httpService, String rel, String resourcePath) {
        String path = (httpService.getBasePath() + "/" + resourcePath).replaceAll("/+", "/");
        httpService.addOasResourceLink("<" + path + ">;" + rel);
    }

    @Override
    public String getName() {
        return String.format("%s%s", RESOURCE_METHOD, this.getResourceName());
    }

    @Override
    public String getPath() {
        return String.format("%s%s", "/", this.getResourceName());
    }

    @Override
    public List<String> getMethods() {
        return List.of("GET");
    }

    @Override
    public List<String> getConsumes() {
        return Collections.emptyList();
    }

    @Override
    public List<String> getProduces() {
        return Collections.emptyList();
    }

    protected abstract String getResourceName();

    public abstract byte[] getPayload();

    public abstract String getContentType();
}

