/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.client.endpoint;

import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.http.api.HttpConnectionManager;
import io.ballerina.stdlib.http.api.HttpConstants;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.transport.contract.HttpClientConnector;
import io.ballerina.stdlib.http.transport.contract.config.SenderConfiguration;
import io.ballerina.stdlib.http.transport.contractimpl.sender.channel.pool.ConnectionManager;
import io.ballerina.stdlib.http.transport.message.HttpConnectorUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

public class CreateSimpleHttpClient {
    public static Object createSimpleHttpClient(BObject httpClient, BMap globalPoolConfig, BString clientUrl, BMap<BString, Object> clientEndpointConfig, BString optionsString) {
        try {
            URL url;
            HttpConnectionManager connectionManager = HttpConnectionManager.getInstance();
            Object urlString = clientUrl.getValue();
            if (!((String)urlString).strip().isEmpty()) {
                String[] urlStrings = ((String)urlString).split("://", 2);
                if (urlStrings.length == 1) {
                    String[] stringArray;
                    if (CreateSimpleHttpClient.isClientSecurityConfigured(clientEndpointConfig)) {
                        String[] stringArray2 = new String[2];
                        stringArray2[0] = "https";
                        stringArray = stringArray2;
                        stringArray2[1] = urlStrings[0];
                    } else {
                        String[] stringArray3 = new String[2];
                        stringArray3[0] = "http";
                        stringArray = stringArray3;
                        stringArray3[1] = urlStrings[0];
                    }
                    urlStrings = stringArray;
                } else if (urlStrings[0].equals("http") && CreateSimpleHttpClient.isClientSecurityConfigured(clientEndpointConfig)) {
                    System.err.println("warning: [ballerina/http] HTTPS is recommended but using HTTP");
                }
                urlStrings[1] = urlStrings[1].replaceAll("//", "/");
                urlString = urlStrings[0] + "://" + urlStrings[1];
            }
            try {
                url = new URL((String)urlString);
            }
            catch (MalformedURLException e) {
                return HttpUtil.createHttpError("malformed URL: " + (String)urlString, HttpErrorType.GENERIC_CLIENT_ERROR);
            }
            String scheme = url.getProtocol();
            Map<String, Object> properties = HttpConnectorUtil.getTransportProperties(connectionManager.getTransportConfig());
            properties.put("ClientConfigHashCode", optionsString.hashCode());
            SenderConfiguration senderConfiguration = new SenderConfiguration();
            senderConfiguration.setScheme(scheme);
            if (connectionManager.isHTTPTraceLoggerEnabled()) {
                senderConfiguration.setHttpTraceLogEnabled(true);
            }
            if (connectionManager.isHTTPAccessLoggerEnabled()) {
                senderConfiguration.setHttpAccessLogEnabled(true);
            }
            senderConfiguration.setTLSStoreType("PKCS12");
            String httpVersion = clientEndpointConfig.getStringValue(HttpConstants.CLIENT_EP_HTTP_VERSION).getValue();
            if ("2.0".equals(httpVersion)) {
                BMap http2Settings = (BMap)clientEndpointConfig.get((Object)HttpConstants.HTTP2_SETTINGS);
                boolean http2PriorKnowledge = (Boolean)http2Settings.get((Object)HttpConstants.HTTP2_PRIOR_KNOWLEDGE);
                senderConfiguration.setForceHttp2(http2PriorKnowledge);
                if (!http2PriorKnowledge) {
                    BMap http1Settings = (BMap)clientEndpointConfig.get((Object)HttpConstants.HTTP1_SETTINGS);
                    senderConfiguration.setKeepAliveConfig(HttpUtil.getKeepAliveConfig(http1Settings.getStringValue(HttpConstants.CLIENT_EP_IS_KEEP_ALIVE).getValue()));
                }
                senderConfiguration.setHttp2InitialWindowSize(http2Settings.getIntValue(HttpConstants.CLIENT_EP_HTTP2_INITIAL_WINDOW_SIZE).intValue());
            } else {
                BMap http1Settings = (BMap)clientEndpointConfig.get((Object)HttpConstants.HTTP1_SETTINGS);
                String chunking = http1Settings.getStringValue(HttpConstants.CLIENT_EP_CHUNKING).getValue();
                senderConfiguration.setChunkingConfig(HttpUtil.getChunkConfig(chunking));
                String keepAliveConfig = http1Settings.getStringValue(HttpConstants.CLIENT_EP_IS_KEEP_ALIVE).getValue();
                senderConfiguration.setKeepAliveConfig(HttpUtil.getKeepAliveConfig(keepAliveConfig));
            }
            BMap responseLimits = (BMap)clientEndpointConfig.get((Object)HttpConstants.RESPONSE_LIMITS);
            HttpUtil.setInboundMgsSizeValidationConfig(responseLimits.getIntValue(HttpConstants.MAX_STATUS_LINE_LENGTH), responseLimits.getIntValue(HttpConstants.MAX_HEADER_SIZE), responseLimits.getIntValue(HttpConstants.MAX_ENTITY_BODY_SIZE), senderConfiguration.getMsgSizeValidationConfig());
            try {
                HttpUtil.populateSenderConfigurations(senderConfiguration, clientEndpointConfig, scheme);
            }
            catch (RuntimeException e) {
                return HttpUtil.createHttpError(e.getMessage(), HttpErrorType.GENERIC_CLIENT_ERROR);
            }
            BMap userDefinedPoolConfig = (BMap)clientEndpointConfig.get((Object)HttpConstants.USER_DEFINED_POOL_CONFIG);
            ConnectionManager poolManager = userDefinedPoolConfig == null ? HttpUtil.getConnectionManager(globalPoolConfig) : HttpUtil.getConnectionManager(userDefinedPoolConfig);
            BMap clientSocketConfig = clientEndpointConfig.getMapValue(HttpConstants.SOCKET_CONFIG);
            if (clientSocketConfig != null) {
                CreateSimpleHttpClient.setClientSocketConfig((BMap<BString, Object>)clientSocketConfig, senderConfiguration);
            }
            HttpClientConnector httpClientConnector = HttpUtil.createHttpWsConnectionFactory().createHttpsClientConnector(properties, senderConfiguration, poolManager);
            httpClient.addNativeData("Client", (Object)httpClientConnector);
            httpClient.addNativeData("url", urlString);
            httpClient.addNativeData("config", clientEndpointConfig);
            return null;
        }
        catch (Exception ex) {
            return ex instanceof BError ? ex : HttpUtil.createHttpError(ex.getMessage(), HttpErrorType.GENERIC_CLIENT_ERROR);
        }
    }

    private static boolean isClientSecurityConfigured(BMap<BString, Object> clientEndpointConfig) {
        return clientEndpointConfig.get((Object)HttpConstants.ENDPOINT_CONFIG_SECURESOCKET) != null || clientEndpointConfig.get((Object)HttpConstants.CLIENT_EP_AUTH) != null;
    }

    private static void setClientSocketConfig(BMap<BString, Object> clientSocketConfig, SenderConfiguration senderConfig) {
        double connectTimeOut = ((BDecimal)clientSocketConfig.get((Object)HttpConstants.SOCKET_CONFIG_CONNECT_TIMEOUT)).floatValue();
        senderConfig.setConnectTimeOut(connectTimeOut);
        int receiveBufferSize = clientSocketConfig.getIntValue(HttpConstants.SOCKET_CONFIG_RECEIVE_BUFFER_SIZE).intValue();
        senderConfig.setReceiveBufferSize(receiveBufferSize);
        int sendBufferSize = clientSocketConfig.getIntValue(HttpConstants.SOCKET_CONFIG_SEND_BUFFER_SIZE).intValue();
        senderConfig.setSendBufferSize(sendBufferSize);
        boolean tcpNoDelay = clientSocketConfig.getBooleanValue(HttpConstants.SOCKET_CONFIG_TCP_NO_DELAY);
        senderConfig.setTcpNoDelay(tcpNoDelay);
        boolean socketReuse = clientSocketConfig.getBooleanValue(HttpConstants.SOCKET_CONFIG_SOCKET_REUSE);
        senderConfig.setSocketReuse(socketReuse);
        boolean keepAlive = clientSocketConfig.getBooleanValue(HttpConstants.SOCKET_CONFIG_KEEP_ALIVE);
        senderConfig.setSocketKeepAlive(keepAlive);
    }

    private CreateSimpleHttpClient() {
    }
}

