/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.logging;

import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.http.api.HttpConstants;
import io.ballerina.stdlib.http.api.logging.accesslog.HttpAccessLogConfig;
import io.ballerina.stdlib.http.api.logging.formatters.HttpAccessLogFormatter;
import io.ballerina.stdlib.http.api.logging.formatters.HttpTraceLogFormatter;
import io.ballerina.stdlib.http.api.logging.formatters.JsonLogFormatter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SocketHandler;

public class HttpLogManager
extends LogManager {
    protected Logger httpTraceLogger;
    protected Logger httpAccessLogger;
    private String protocol;

    public HttpLogManager(boolean traceLogConsole, BMap traceLogAdvancedConfig, BMap accessLogConfig, BString protocol) {
        this.protocol = protocol.getValue();
        this.setHttpTraceLogHandler(traceLogConsole, traceLogAdvancedConfig);
        this.setHttpAccessLogHandler(accessLogConfig);
        HttpAccessLogConfig.getInstance().initializeHttpAccessLogConfig(accessLogConfig);
    }

    public void setHttpTraceLogHandler(boolean traceLogConsole, BMap traceLogAdvancedConfig) {
        BString logFilePath;
        if (this.httpTraceLogger == null) {
            this.httpTraceLogger = Logger.getLogger("http.tracelog");
        }
        PrintStream stdErr = System.err;
        boolean traceLogsEnabled = false;
        Boolean consoleLogEnabled = traceLogAdvancedConfig.getBooleanValue(HttpConstants.HTTP_LOG_CONSOLE);
        if (traceLogConsole || consoleLogEnabled.booleanValue()) {
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setFormatter(new HttpTraceLogFormatter());
            consoleHandler.setLevel(Level.FINEST);
            this.httpTraceLogger.addHandler(consoleHandler);
            traceLogsEnabled = true;
        }
        if ((logFilePath = traceLogAdvancedConfig.getStringValue(HttpConstants.HTTP_LOG_FILE_PATH)) != null && !logFilePath.getValue().trim().isEmpty()) {
            try {
                FileHandler fileHandler = new FileHandler(logFilePath.getValue(), true);
                fileHandler.setFormatter(new HttpTraceLogFormatter());
                fileHandler.setLevel(Level.FINEST);
                this.httpTraceLogger.addHandler(fileHandler);
                traceLogsEnabled = true;
            }
            catch (IOException e) {
                throw new RuntimeException("failed to setup HTTP trace log file: " + logFilePath.getValue(), e);
            }
        }
        BString host = traceLogAdvancedConfig.getStringValue(HttpConstants.HTTP_TRACE_LOG_HOST);
        Long port = traceLogAdvancedConfig.getIntValue(HttpConstants.HTTP_TRACE_LOG_PORT);
        if (host != null && !host.getValue().trim().isEmpty() && port != null && port != 0L) {
            try {
                SocketHandler socketHandler = new SocketHandler(host.getValue(), port.intValue());
                socketHandler.setFormatter(new JsonLogFormatter());
                socketHandler.setLevel(Level.FINEST);
                this.httpTraceLogger.addHandler(socketHandler);
                traceLogsEnabled = true;
            }
            catch (IOException e) {
                throw new RuntimeException("failed to connect to " + host.getValue() + ":" + port.intValue(), e);
            }
        }
        if (traceLogsEnabled) {
            this.httpTraceLogger.setLevel(Level.FINEST);
            System.setProperty("http.tracelog.enabled", "true");
            stdErr.println("ballerina: " + this.protocol + " trace log enabled");
        }
    }

    public void setHttpAccessLogHandler(BMap accessLogConfig) {
        BArray logAttributes;
        BString logFormat;
        BString filePath;
        if (this.httpAccessLogger == null) {
            this.httpAccessLogger = Logger.getLogger("http.accesslog");
        }
        PrintStream stdErr = System.err;
        boolean accessLogsEnabled = false;
        Boolean consoleLogEnabled = accessLogConfig.getBooleanValue(HttpConstants.HTTP_LOG_CONSOLE);
        if (consoleLogEnabled.booleanValue()) {
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setFormatter(new HttpAccessLogFormatter());
            consoleHandler.setLevel(Level.INFO);
            this.httpAccessLogger.addHandler(consoleHandler);
            this.httpAccessLogger.setLevel(Level.INFO);
            accessLogsEnabled = true;
        }
        if ((filePath = accessLogConfig.getStringValue(HttpConstants.HTTP_LOG_FILE_PATH)) != null && !filePath.getValue().trim().isEmpty()) {
            try {
                FileHandler fileHandler = new FileHandler(filePath.getValue(), true);
                fileHandler.setFormatter(new HttpAccessLogFormatter());
                fileHandler.setLevel(Level.INFO);
                this.httpAccessLogger.addHandler(fileHandler);
                this.httpAccessLogger.setLevel(Level.INFO);
                accessLogsEnabled = true;
            }
            catch (IOException e) {
                throw new RuntimeException("failed to setup HTTP access log file: " + filePath.getValue(), e);
            }
        }
        if ((logFormat = accessLogConfig.getStringValue(HttpConstants.HTTP_LOG_FORMAT)) != null && !logFormat.getValue().equals("json") && !logFormat.getValue().equals("flat")) {
            stdErr.println("WARNING: Unsupported log format '" + logFormat.getValue() + "'. Defaulting to 'flat' format.");
        }
        if ((logAttributes = accessLogConfig.getArrayValue(HttpConstants.HTTP_LOG_ATTRIBUTES)) != null && logAttributes.getLength() == 0L) {
            accessLogsEnabled = false;
        }
        if (accessLogsEnabled) {
            System.setProperty("http.accesslog.enabled", "true");
            stdErr.println("ballerina: " + this.protocol + " access log enabled");
        }
    }

    static {
        try (InputStream is = HttpLogManager.class.getClassLoader().getResourceAsStream("logging.properties");){
            LogManager.getLogManager().readConfiguration(is);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to read logging.properties file from the classpath", e);
        }
    }
}

