/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.logging.formatters;

import io.ballerina.stdlib.http.api.logging.HttpLogManager;
import io.ballerina.stdlib.http.api.logging.util.LogLevelMapper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class HttpTraceLogFormatter
extends Formatter {
    private static String format = HttpLogManager.getLogManager().getProperty(HttpTraceLogFormatter.class.getCanonicalName() + ".format");

    @Override
    public String format(LogRecord record) {
        String source = record.getLoggerName();
        String ex = "";
        if (record.getThrown() != null) {
            StringWriter stringWriter = new StringWriter();
            stringWriter.append('\n');
            record.getThrown().printStackTrace(new PrintWriter(stringWriter));
            ex = stringWriter.toString();
        }
        return String.format(format, new Date(record.getMillis()), LogLevelMapper.getBallerinaLogLevel(record.getLevel()), source, record.getMessage(), ex);
    }
}

