/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.service.endpoint;

import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.http.api.HttpConnectionManager;
import io.ballerina.stdlib.http.api.HttpConstants;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.service.endpoint.AbstractHttpNativeFunction;
import io.ballerina.stdlib.http.transport.contract.ServerConnector;
import io.ballerina.stdlib.http.transport.contract.config.ListenerConfiguration;

public class InitEndpoint
extends AbstractHttpNativeFunction {
    public static Object initEndpoint(BObject serviceEndpoint, BMap serviceEndpointConfig) {
        try {
            serviceEndpoint.addNativeData("config", (Object)serviceEndpointConfig);
            long port = serviceEndpoint.getIntValue(HttpConstants.ENDPOINT_CONFIG_PORT);
            ListenerConfiguration listenerConfiguration = HttpUtil.getListenerConfig(port, serviceEndpointConfig);
            ServerConnector httpServerConnector = HttpConnectionManager.getInstance().createHttpServerConnector(listenerConfiguration);
            serviceEndpoint.addNativeData("HTTP_SERVER_CONNECTOR", (Object)httpServerConnector);
            InitEndpoint.resetRegistry(serviceEndpoint);
            return null;
        }
        catch (BError errorValue) {
            return HttpUtil.createHttpError(errorValue.getMessage(), HttpErrorType.GENERIC_LISTENER_ERROR, errorValue.getCause());
        }
        catch (Exception e) {
            return HttpUtil.createHttpError(e.getMessage(), HttpErrorType.GENERIC_LISTENER_ERROR);
        }
    }

    private InitEndpoint() {
    }
}

