/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.service.signature;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.FiniteType;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.TypeTags;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.JsonUtils;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.utils.ValueUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.http.api.BallerinaConnectorException;
import io.ballerina.stdlib.http.api.HttpUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ParamUtils {
    public static Object castParam(int targetParamTypeTag, String argValue) {
        try {
            switch (targetParamTypeTag) {
                case 1: {
                    return Long.parseLong(argValue);
                }
                case 3: {
                    return Double.parseDouble(argValue);
                }
                case 6: {
                    return Boolean.parseBoolean(argValue);
                }
                case 4: {
                    return ValueCreator.createDecimalValue((String)argValue);
                }
                case 24: 
                case 27: {
                    return JsonUtils.parse((String)argValue);
                }
            }
            return StringUtils.fromString((String)argValue);
        }
        catch (Exception exp) {
            String errorMessage = "error occurred while converting '" + argValue + "' to the target type";
            if (exp instanceof BError) {
                throw ErrorCreator.createError((BString)StringUtils.fromString((String)errorMessage), (Throwable)exp);
            }
            throw ErrorCreator.createError((BString)StringUtils.fromString((String)errorMessage));
        }
    }

    public static BArray castParamArray(Type elementType, String[] argValueArr) {
        int targetElementTypeTag = elementType.getTag();
        switch (targetElementTypeTag) {
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 24: 
            case 27: {
                try {
                    return ParamUtils.getBArray(argValueArr, TypeCreator.createArrayType((Type)elementType), elementType);
                }
                catch (Exception exp) {
                    String errorMessage = "error occurred while converting '" + String.valueOf(argValueArr) + "' to the target array type";
                    if (exp instanceof BError) {
                        throw ErrorCreator.createError((BString)StringUtils.fromString((String)errorMessage), (Throwable)exp);
                    }
                    throw ErrorCreator.createError((BString)StringUtils.fromString((String)errorMessage));
                }
            }
        }
        return StringUtils.fromStringArray((String[])argValueArr);
    }

    public static BArray castParamArray(int elementTypeTag, String[] argValueArr) {
        ArrayList<Object> parsedValues = new ArrayList<Object>();
        for (String argValue : argValueArr) {
            parsedValues.add(ParamUtils.castParam(elementTypeTag, argValue));
        }
        return ValueCreator.createArrayValue((Object[])parsedValues.toArray(), (ArrayType)TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_JSON));
    }

    private static BArray getBArray(String[] valueArray, ArrayType arrayType, Type elementType) {
        BArray arrayValue = ValueCreator.createArrayValue((ArrayType)arrayType);
        int index = 0;
        int elementTypeTag = elementType.getTag();
        block7: for (String element : valueArray) {
            switch (elementTypeTag) {
                case 1: {
                    arrayValue.add((long)index++, Long.parseLong(element));
                    continue block7;
                }
                case 3: {
                    arrayValue.add((long)index++, Double.parseDouble(element));
                    continue block7;
                }
                case 6: {
                    arrayValue.add((long)index++, Boolean.parseBoolean(element));
                    continue block7;
                }
                case 4: {
                    arrayValue.add((long)index++, (Object)ValueCreator.createDecimalValue((String)element));
                    continue block7;
                }
                case 24: 
                case 27: {
                    Object record = JsonUtils.parse((String)element);
                    arrayValue.add((long)index++, ValueUtils.convert((Object)record, (Type)elementType));
                    continue block7;
                }
                default: {
                    throw new BallerinaConnectorException("Illegal state error: unexpected param type");
                }
            }
        }
        return arrayValue;
    }

    public static boolean isArrayType(Type type) {
        List constituentTypes;
        Type referredType = TypeUtils.getReferredType((Type)type);
        int referredTypeTag = referredType.getTag();
        if (referredTypeTag == 32) {
            return true;
        }
        if (referredTypeTag == 33) {
            List memberTypes = ((UnionType)referredType).getMemberTypes();
            return memberTypes.stream().allMatch(memberType -> ParamUtils.isArrayType(memberType) || memberType.getTag() == 14);
        }
        if (referredTypeTag == 34 && (constituentTypes = ((IntersectionType)referredType).getConstituentTypes()).size() == 2) {
            if (((Type)constituentTypes.get(0)).getTag() == 51) {
                return ParamUtils.isArrayType((Type)constituentTypes.get(1));
            }
            if (((Type)constituentTypes.get(1)).getTag() == 51) {
                return ParamUtils.isArrayType((Type)constituentTypes.get(0));
            }
        }
        return false;
    }

    public static RecordType getRecordType(Type type) {
        List constituentTypes;
        Type referredType = TypeUtils.getReferredType((Type)type);
        int referredTypeTag = referredType.getTag();
        if (referredTypeTag == 24) {
            return (RecordType)referredType;
        }
        if (referredTypeTag == 33) {
            List memberTypes = ((UnionType)referredType).getMemberTypes();
            if (memberTypes.size() == 2) {
                if (((Type)memberTypes.get(0)).getTag() == 14) {
                    return ParamUtils.getRecordType((Type)memberTypes.get(1));
                }
                if (((Type)memberTypes.get(1)).getTag() == 14) {
                    return ParamUtils.getRecordType((Type)memberTypes.get(0));
                }
            }
        } else if (referredTypeTag == 34 && (constituentTypes = ((IntersectionType)referredType).getConstituentTypes()).size() == 2) {
            if (((Type)constituentTypes.get(0)).getTag() == 51) {
                return ParamUtils.getRecordType((Type)constituentTypes.get(1));
            }
            if (((Type)constituentTypes.get(1)).getTag() == 51) {
                return ParamUtils.getRecordType((Type)constituentTypes.get(0));
            }
        }
        return null;
    }

    public static boolean isFiniteType(Type type) {
        Type referredType = TypeUtils.getReferredType((Type)type);
        int referredTypeTag = referredType.getTag();
        if (referredTypeTag == 46) {
            return true;
        }
        if (referredTypeTag == 33) {
            List memberTypes = ((UnionType)referredType).getMemberTypes();
            return memberTypes.stream().allMatch(memberType -> ParamUtils.isFiniteType(memberType) || memberType.getTag() == 14);
        }
        if (referredTypeTag == 34) {
            List constituentTypes = ((IntersectionType)referredType).getConstituentTypes();
            if (constituentTypes.size() == 2) {
                if (((Type)constituentTypes.get(0)).getTag() == 51) {
                    return ParamUtils.isFiniteType((Type)constituentTypes.get(1));
                }
                if (((Type)constituentTypes.get(1)).getTag() == 51) {
                    return ParamUtils.isFiniteType((Type)constituentTypes.get(0));
                }
            }
        } else if (referredTypeTag == 32) {
            return ParamUtils.isFiniteType(((ArrayType)referredType).getElementType());
        }
        return false;
    }

    public static int getEffectiveTypeTag(Type type, Type originalType, String paramType) {
        Type referredType = TypeUtils.getReferredType((Type)type);
        int referredTypeTag = referredType.getTag();
        if (TypeTags.isIntegerTypeTag((int)referredTypeTag)) {
            return 1;
        }
        if (TypeTags.isStringTypeTag((int)referredTypeTag)) {
            return 5;
        }
        switch (referredTypeTag) {
            case 3: 
            case 4: 
            case 6: {
                return referredTypeTag;
            }
            case 24: 
            case 27: {
                if (!paramType.equals("query")) break;
                return 27;
            }
            case 32: {
                return ParamUtils.getEffectiveTypeTagFromArrayType((ArrayType)referredType, originalType, paramType);
            }
            case 33: {
                return ParamUtils.getEffectiveTypeTagFromUnionType((UnionType)referredType, originalType, paramType);
            }
            case 46: {
                return ParamUtils.getEffectiveTypeTagFromFiniteType((FiniteType)referredType, originalType, paramType);
            }
            case 34: {
                return ParamUtils.getEffectiveTypeTagFromIntersectionType((IntersectionType)referredType, originalType, paramType);
            }
        }
        throw HttpUtil.createHttpError("invalid " + paramType + " parameter type '" + String.valueOf(originalType) + "'");
    }

    private static int getEffectiveTypeTagFromArrayType(ArrayType type, Type originalType, String paramType) {
        Type elementType = TypeUtils.getReferredType((Type)type.getElementType());
        if (elementType.getTag() == 32) {
            throw HttpUtil.createHttpError("invalid " + paramType + " parameter array type '" + String.valueOf(originalType) + "'");
        }
        return ParamUtils.getEffectiveTypeTag(elementType, originalType, paramType);
    }

    private static int getEffectiveTypeTagFromUnionType(UnionType type, Type originalType, String paramType) {
        List memberTypes = type.getMemberTypes();
        ArrayList<Integer> memberTypeTags = new ArrayList<Integer>();
        for (Type memberType : memberTypes) {
            Type referredType = TypeUtils.getReferredType((Type)memberType);
            if (referredType.getTag() == 14 && !paramType.equals("path")) continue;
            memberTypeTags.add(ParamUtils.getEffectiveTypeTag(referredType, originalType, paramType));
        }
        if (memberTypeTags.stream().allMatch(memberTypeTag -> memberTypeTag.equals(memberTypeTags.get(0)))) {
            return (Integer)memberTypeTags.get(0);
        }
        throw HttpUtil.createHttpError("invalid " + paramType + " parameter union type '" + String.valueOf(originalType) + "'");
    }

    private static int getEffectiveTypeTagFromFiniteType(FiniteType type, Type originalType, String paramType) {
        Set valueSpace = type.getValueSpace();
        ArrayList<Integer> valueSpaceMemberTypeTags = new ArrayList<Integer>();
        for (Object value : valueSpace) {
            Type referredType = TypeUtils.getReferredType((Type)TypeUtils.getType(value));
            if (referredType.getTag() == 14 && !paramType.equals("path")) continue;
            valueSpaceMemberTypeTags.add(ParamUtils.getEffectiveTypeTag(TypeUtils.getType(value), originalType, paramType));
        }
        if (valueSpaceMemberTypeTags.stream().allMatch(memberTypeTag -> memberTypeTag.equals(valueSpaceMemberTypeTags.get(0)))) {
            return (Integer)valueSpaceMemberTypeTags.get(0);
        }
        throw HttpUtil.createHttpError("invalid " + paramType + " parameter finite type '" + String.valueOf(originalType) + "'");
    }

    private static int getEffectiveTypeTagFromIntersectionType(IntersectionType type, Type originalType, String paramType) {
        List constituentTypes = type.getConstituentTypes();
        if (constituentTypes.size() == 2) {
            if (((Type)constituentTypes.get(0)).getTag() == 51) {
                return ParamUtils.getEffectiveTypeTag((Type)constituentTypes.get(1), originalType, paramType);
            }
            if (((Type)constituentTypes.get(1)).getTag() == 51) {
                return ParamUtils.getEffectiveTypeTag((Type)constituentTypes.get(0), originalType, paramType);
            }
        }
        throw HttpUtil.createHttpError("invalid " + paramType + " parameter intersection type '" + String.valueOf(originalType) + "'");
    }

    private ParamUtils() {
    }
}

