/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.service.signature.converter;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.http.api.BallerinaConnectorException;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpUtil;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class UrlEncodedStringToMapConverter {
    private static final MapType STRING_MAP = TypeCreator.createMapType((Type)PredefinedTypes.TYPE_STRING);

    public static Object convert(MapType type, BString dataSource, boolean readonly) {
        Type constrainedType = type.getConstrainedType();
        if (constrainedType.getTag() == 5) {
            BMap<BString, Object> formParamMap = UrlEncodedStringToMapConverter.getFormParamMap(dataSource);
            if (readonly) {
                formParamMap.freezeDirect();
            }
            return formParamMap;
        }
        String message = "incompatible type found: '" + type.toString() + "'";
        throw HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_PAYLOAD_BINDING_LISTENER_ERROR, message);
    }

    private static BMap<BString, Object> getFormParamMap(Object stringDataSource) {
        try {
            String formData = ((BString)stringDataSource).getValue();
            BMap formParamsMap = ValueCreator.createMapValue((MapType)STRING_MAP);
            if (formData.isEmpty()) {
                return formParamsMap;
            }
            HashMap<String, String> tempParamMap = new HashMap<String, String>();
            if (!formData.contains("=")) {
                throw new BallerinaConnectorException("Datasource does not contain form data");
            }
            String[] formParamValues = formData.split("&");
            for (String formParam : formParamValues) {
                int index = formParam.indexOf(61);
                if (index == -1) {
                    String decodedFormParam = URLDecoder.decode(formParam, StandardCharsets.UTF_8);
                    if (tempParamMap.containsKey(decodedFormParam)) continue;
                    tempParamMap.put(decodedFormParam, null);
                    continue;
                }
                String decodedFormParamName = URLDecoder.decode(formParam.substring(0, index).trim(), StandardCharsets.UTF_8);
                String decodedFormParamValue = URLDecoder.decode(formParam.substring(index + 1).trim(), StandardCharsets.UTF_8);
                tempParamMap.put(decodedFormParamName, decodedFormParamValue);
            }
            for (Map.Entry entry : tempParamMap.entrySet()) {
                String entryValue = (String)entry.getValue();
                if (entryValue != null) {
                    formParamsMap.put((Object)StringUtils.fromString((String)((String)entry.getKey())), (Object)StringUtils.fromString((String)entryValue));
                    continue;
                }
                formParamsMap.put((Object)StringUtils.fromString((String)((String)entry.getKey())), null);
            }
            return formParamsMap;
        }
        catch (Exception ex) {
            throw ErrorCreator.createError((BString)StringUtils.fromString((String)("Could not convert payload to map<string>: " + ex.getMessage())));
        }
    }

    private UrlEncodedStringToMapConverter() {
    }
}

