/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contract.websocket;

import io.ballerina.stdlib.http.transport.contract.config.SslConfiguration;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import java.net.URI;
import java.util.Map;

public class WebSocketClientConnectorConfig
extends SslConfiguration {
    private final String remoteAddress;
    private String subProtocols;
    private int idleTimeoutInSeconds;
    private boolean autoRead;
    private final HttpHeaders headers;
    private int maxFrameSize = 65536;
    private boolean webSocketCompressionEnabled;

    public WebSocketClientConnectorConfig(String remoteAddress) {
        this.remoteAddress = remoteAddress;
        this.headers = new DefaultHttpHeaders();
        this.setScheme("wss".equals(URI.create(remoteAddress).getScheme()) ? "https" : "http");
    }

    public String getSubProtocolsStr() {
        if (this.subProtocols == null) {
            return null;
        }
        return this.subProtocols;
    }

    public void setSubProtocols(String[] subProtocols) {
        if (subProtocols == null || subProtocols.length == 0) {
            this.subProtocols = null;
            return;
        }
        this.subProtocols = String.join((CharSequence)",", subProtocols);
    }

    public boolean isAutoRead() {
        return this.autoRead;
    }

    public void setAutoRead(boolean autoRead) {
        this.autoRead = autoRead;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public void addHeaders(Map<String, String> headers) {
        headers.forEach((arg_0, arg_1) -> ((HttpHeaders)this.headers).add(arg_0, arg_1));
    }

    public void addHeader(String key, String value) {
        this.headers.add(key, (Object)value);
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public boolean containsHeader(String key) {
        return this.headers.contains(key);
    }

    public int getIdleTimeoutInMillis() {
        return this.idleTimeoutInSeconds;
    }

    public void setIdleTimeoutInMillis(int idleTimeoutInSeconds) {
        this.idleTimeoutInSeconds = idleTimeoutInSeconds;
    }

    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public void setMaxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    public boolean isWebSocketCompressionEnabled() {
        return this.webSocketCompressionEnabled;
    }

    public void setWebSocketCompressionEnabled(boolean webSocketCompressionEnabled) {
        this.webSocketCompressionEnabled = webSocketCompressionEnabled;
    }
}

