/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.common.certificatevalidation.pathvalidation;

import io.ballerina.stdlib.http.transport.contractimpl.common.certificatevalidation.CertificateVerificationException;
import io.ballerina.stdlib.http.transport.contractimpl.common.certificatevalidation.RevocationVerifier;
import io.ballerina.stdlib.http.transport.contractimpl.common.certificatevalidation.pathvalidation.PathChecker;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificatePathValidator {
    private PathChecker pathChecker;
    private List<X509Certificate> fullCertChain;
    private List<X509Certificate> certChain;
    private static final Logger LOG = LoggerFactory.getLogger(CertificatePathValidator.class);

    public CertificatePathValidator(X509Certificate[] certChainArray, RevocationVerifier verifier) {
        this.pathChecker = new PathChecker(certChainArray, verifier);
        this.init(certChainArray);
    }

    private void init(X509Certificate[] certChainArray) {
        X509Certificate[] partCertChainArray = new X509Certificate[certChainArray.length - 1];
        System.arraycopy(certChainArray, 0, partCertChainArray, 0, partCertChainArray.length);
        this.certChain = Arrays.asList(partCertChainArray);
        this.fullCertChain = Arrays.asList(certChainArray);
    }

    public void validatePath() throws CertificateVerificationException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        CollectionCertStoreParameters params = new CollectionCertStoreParameters(this.fullCertChain);
        try {
            CertStore store = CertStore.getInstance("Collection", (CertStoreParameters)params, "BC");
            CertificateFactory fact = CertificateFactory.getInstance("X.509", "BC");
            CertPath certPath = fact.generateCertPath(this.certChain);
            TrustAnchor trustAnchor = new TrustAnchor(this.fullCertChain.get(this.fullCertChain.size() - 1), null);
            Set<TrustAnchor> trust = Collections.singleton(trustAnchor);
            CertPathValidator validator = CertPathValidator.getInstance("PKIX", "BC");
            PKIXParameters param = new PKIXParameters(trust);
            param.addCertPathChecker(this.pathChecker);
            param.setRevocationEnabled(false);
            param.addCertStore(store);
            param.setDate(new Date());
            validator.validate(certPath, param);
            if (LOG.isInfoEnabled()) {
                LOG.info("Certificate path validated");
            }
        }
        catch (CertPathValidatorException e) {
            throw new CertificateVerificationException("Certificate path validation failed on certificate number " + e.getIndex() + ", details: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new CertificateVerificationException("Certificate path validation failed", e);
        }
    }
}

